/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.action.RequestProcessorEx;
import jp.terasoluna.fw.web.struts.form.FormEx;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessages;

/**
 * ANVNXB
 *
 * <p>
 *  StrutsActionɁAOo͋@\EgUNV
 *  g[N`FbN@\ǉĂB<br>
 *  ̋@\𗘗pꍇ́A{NXp邱ƁB<br>
 *  {NX𗘗p邽߂ɂ́AdoExecute()\bh
 *  I[oChTuNX쐬Astruts-config.xml
 *  &lt;action&gt;vftypeŃNXݒ肷B<br>
 *  gUNVg[N`FbNƂ́ATu~bgQxA
 *  uEÚu߂v{^gdTu~bgh@\łB<br>
 *  gUNVg[N`FbNs߂ɂ́Aȉ̐ݒ
 *  sKvB
 *  <ul>
 *   <li>
 *     ANVNXBean`
 *     &lt;property&gt;vf
 *     &quot;tokenCheck&quot;ɑ΂A
 *     &quot;true&quot;𖾎Kv
 *   </li>
 *   <li>
 *     struts-config.xml
 *     &lt;forward&gt;vfi&lt;grobal-forwards&gt;
 *     łj&quot;txtoken-error&quot;ƂO
 *     g[NG[̃pXw肷
 *   </li>
 *  </ul>
 *  ActionExgpꍇAsaveToken()
 *  ĎIɃg[Nۑ邪AۑȂꍇɂ͈ȉ̐ݒs
 *  KvB<br>
 *  <ul>
 *   <li>
 *     ANVNXBean`
 *     &lt;property&gt;vf
 *     &quot;saveToken&quot;ɑ΂A
 *     &quot;false&quot;𖾎Kv
 *   </li>
 *  </ul>
 *  gUNVg[N`FbN܂߂struts-config.xml
 *  yBean`t@C̐ݒALɎB<br>
 * </p>
 * <p>
 *  <strong>TuNXLogoffActionBean`t@C̐ݒ</strong>
 *  <code><pre>
 *  &lt;bean name="/admin/Logout" scope="prototype"
 *      class="jp.terasoluna.fw.web.struts.actions.LogoffAction"&gt
 *    &lt;property property="tokenCheck"&gt;
 *      &lt;value&gt;true&lt;/value&gt;
 *    &lt;/property&gt;
 *    &lt;property property="saveToken"&gt;
 *      &lt;value&gt;false&lt;/value&gt;
 *    &lt;/property&gt;
 *  &lt;/bean&gt
 *  </pre></code>
 * </p>
 * <p>
 *  <strong>TuNXLogoffActionstruts-config.xml̐ݒ</strong>
 *  <code><pre>
 *  &lt;action path="/admin/Logout"
 *      name="logonSampleForm"
 *      scope="session"
 *      parameter="/sub/logout.jsp"&gt
 *    &lt;forward name="txtoken-error" modeule="/sub"
 *        path="/doubleRegistError.jsp"/&gt
 *  &lt;/action&gt
 *  </pre></code>
 *
 *  ȂAvfforwardŁApath̐擪ɃXbV
 *  &quot;/&quot;tAmoduleݒ肵ꍇA
 *  W[Ƃ̑΃pXőJڂ邱ƂłB<br>
 *  ܂A{@\TuNXŌpꍇAdoExecute()\bh
 *  Gg|CgƂĎKvB<br>
 *  ANV}bsO̐ݒɂẮAActionMappingExQƂ̂ƁB
 * </p>
 *
 * @see jp.terasoluna.fw.web.struts.action.ActionMappingEx
 *
 */
public abstract class ActionEx extends Action {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(ActionEx.class);

    /**
     * gUNVg[N`FbNG[̘_tH[hB
     */
    protected static final String FORWARD_TXTOKEN_ERROR = "txtoken-error";

    /**
     * gUNVg[N`FbNsǂB
     * ftHgfalseisȂjB
     */
    private boolean tokenCheck = false;

    /**
     * gUNVg[N̕ۑ邩ǂB
     * ftHgtrueiۑjB
     */
    private boolean saveToken = true;

    /**
     * gUNVg[N`FbNtOݒ肷B
     *
     * @param tokenCheck gUNVg[N`FbNtO
     */
    public void setTokenCheck(boolean tokenCheck) {
        this.tokenCheck = tokenCheck;
    }

    /**
     * gUNVg[NۑtOݒ肷B
     *
     * @param saveToken gUNVg[NۑtO
     */
    public void setSaveToken(boolean saveToken) {
        this.saveToken = saveToken;
    }
    
    /**
     * gUNVg[N`FbNtO擾B
     *
     * @return gUNVg[N`FbNtO
     */
    protected boolean isTokenCheck() {
        return tokenCheck;
    }
    
    /**
     * gUNVg[NۑtO擾
     *
     * @return gUNVg[NۑtO
     */
    protected boolean isSaveToken() {
        return saveToken;
    }

    /**
     * ANVsB
     * <p>
     *  TuNXŎꂽdoExecute()\bhĂяoOɁA
     *  ANVtH[modifiedfalseɏB<br>
     *  doExecute()̎sAANVtH[
     *  tB[hlɕύX΃NGXgSKIP_POPULATE
     *  ۑARequestProcessorEx
     *  processPopulate()̏}ĂB
     * </p>
     *
     * @param mapping ̃ANVɕRÂANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return Jڐ
     * @throws Exception ANVs̗O
     */
    @Override
    public ActionForward execute(ActionMapping mapping,
                                 ActionForm form,
                                 HttpServletRequest request,
                                 HttpServletResponse response)
            throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("execute() called.");
        }

        if (!processTokenCheck(mapping, request)) {
            if (log.isInfoEnabled()) {
                log.info("Transaction token error.");                
            }
            if (log.isDebugEnabled()) {
                log.debug("forward = " + FORWARD_TXTOKEN_ERROR);
            }
            return mapping.findForward(FORWARD_TXTOKEN_ERROR);
        }

        if (form != null && form instanceof FormEx) {
            FormEx formEx = (FormEx) form;
            formEx.setModified(false);
        }

        if (log.isDebugEnabled()) {
            log.debug("doExecute() called.");
        }
        ActionForward forward = doExecute(mapping, form, request, response);
        if (log.isDebugEnabled()) {
            log.debug("doExecute() finished.");
        }

        if (form != null && form instanceof FormEx) {
            FormEx formEx = (FormEx) form;
            if (formEx.isModified()) {
                request.setAttribute(RequestProcessorEx.SKIP_POPULATE,
                    mapping.getName());
            }
        }

        if (log.isDebugEnabled()) {
            if (forward != null) {
                log.debug("forward = " + forward.getName()
                    + "(" + forward.getPath() + ")");
            } else {
                log.debug("forward = null");
            }
        }

        return forward;
    }

    /**
     * ANVs钊ۃ\bhB
     * <p>
     *  ̃\bhTuNXŃI[o[ChA
     *  ANV̋@\gB
     * </p>
     *
     * @param mapping ̃ANVɕRÂANV}bsO
     * @param form ANVtH[
     * @param request NGXg
     * @param response X|X
     * @return Jڐ
     * @throws Exception \ȂO
     */
    public abstract ActionForward doExecute(ActionMapping mapping,
                                            ActionForm form,
                                            HttpServletRequest request,
                                            HttpServletResponse response)
        throws Exception;

    /**
     * gUNVg[Ñ`FbNsB
     *
     * @param mapping ANV}bsO
     * @param req HTTPNGXg
     * @return g[Nł <code>true</code>
     */
    protected boolean processTokenCheck(ActionMapping mapping,
                                        HttpServletRequest req) {
        if (log.isDebugEnabled()) {
            log.debug("processTokenCheck() called.");
        }

        // mappingActionMappingExł͂ȂƂAtrueԋp
        if (!(mapping instanceof ActionMappingEx)) {
            if (log.isDebugEnabled()) {
                log.debug("mapping is not instance of ActionMappingEx.");
            }
            return true;
        }

        boolean result = true;
        synchronized (req.getSession().getId().intern()) {
            if (tokenCheck) {
                if (!isTokenValid(req)) {
                    result = false;
                }
            }
            if (saveToken) {
                saveToken(req);
            }
        }
        return result;
    }

    /**
     * ZbVAGlobals.ERROR_KEYL[Ƃ
     * ActionMessages擾Aǉɍēxi[sB
     *
     * @param session ZbV
     * @param errors G[bZ[W
     */
    protected void addErrors(HttpSession session, ActionMessages errors) {

        if (session == null) {
            return;
        }
        
        if (errors == null) {
            return;
        }

        // ZbVG[bZ[W擾A܂͐VΏۂ쐬
        ActionMessages sessionErrors =
            (ActionMessages) session.getAttribute(Globals.ERROR_KEY);
        if (sessionErrors == null) {
            sessionErrors = new ActionMessages();
        }
        // ݃G[ǉ
        sessionErrors.add(errors);

        // ܂AG[bZ[W񂪋̏ꍇAZbV̑SẴG[bZ[W폜
        if (sessionErrors.isEmpty()) {
            session.removeAttribute(Globals.ERROR_KEY);
            return;
        }

        // ZbVɃG[bZ[Wۑ
        session.setAttribute(Globals.ERROR_KEY, sessionErrors);

    }

    /**
     * ZbVAGlobals.MESSAGE_KEYL[Ƃ
     * ActionMessages擾Aǉɍēxi[sB
     *
     * @param session ZbV
     * @param messages bZ[W
     */
    protected void addMessages(HttpSession session, ActionMessages messages) {

        if (session == null) {
            return;
        }
        
        if (messages == null) {
            return;
        }

        // ZbV烁bZ[W擾A܂͐VΏۂ쐬
        ActionMessages sessionMessages =
            (ActionMessages) session.getAttribute(Globals.MESSAGE_KEY);
        if (sessionMessages == null) {
            sessionMessages = new ActionMessages();
        }
        // ݃bZ[Wǉ
        sessionMessages.add(messages);

        // ܂AbZ[W񂪋̏ꍇAZbV̑SẴbZ[W폜
        if (sessionMessages.isEmpty()) {
            session.removeAttribute(Globals.MESSAGE_KEY);
            return;
        }

        // ZbVɃbZ[Wۑ
        session.setAttribute(Globals.MESSAGE_KEY, sessionMessages);
    }

}
