/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.exception;

import jp.terasoluna.fw.service.thin.BLogicMessages;

/**
 * 入力値に不備があり、検証に失敗したために後続の業務処理が
 * 実行できないことをクライアントに通知するための汎用例外クラスです。
 * メッセージ情報一覧を指定できます。
 * 
 * @version 1.0.0
 */
public class ValidationException extends BLogicException {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -8843559335258660652L;

    /**
     * ValidationExceptionのインスタンスを構築します。
     * 
     * @param bLogicMessages メッセージ情報一覧
     */
    public ValidationException(BLogicMessages bLogicMessages) {
        super(bLogicMessages);
    }
}
