/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.exception;

import jp.terasoluna.fw.service.thin.BLogicMessages;

/**
 * BLogic実行中に何らかの不都合が発生し、処理が続行できないことを
 * クライアントに通知するための抽象例外クラスです。 
 * メッセージ情報一覧を指定できます。
 * 
 * @version 1.0.0
 */
public abstract class BLogicException extends RuntimeException {

    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = -8930961033142346339L;

    /**
     * メッセージ情報一覧
     */
    private BLogicMessages bLogicMessages;

    /**
     * BLogicExceptionのインスタンスを構築します。
     * 
     * @param bLogicMessages メッセージ情報一覧
     */
    protected BLogicException(BLogicMessages bLogicMessages) {
        this.bLogicMessages = bLogicMessages;
    }

    /**
     * メッセージ情報の一覧を取得します。
     * 
     * @return メッセージ情報一覧
     */
    public BLogicMessages getBLogicMessages() {
        return bLogicMessages;
    }
}
