/*
 * Copyright (c) 2012 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.ex.aop.log;

import static org.junit.Assert.*;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import org.junit.Test;

/**
 * BLogicクラス処理実行前後のデバッグログを出力するための
 * インタセプタのテストケースクラス
 * @version 1.0.0
 */
public class BLogicLogInterceptorTest {

    /**
     * testCheckException01()<br>
     * 例外リストにない例外が発生した場合、メソッド実行結果が
     * trueとなることを確認する<br>
     * <p>
     * リスト内の例外：RuntimeException<br>
     * 発生したの例外：SQLException<br>
     * </p>
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException01() throws Exception{
        
        //例外リストのインスタンス化
        List<Class> exceptionList = new ArrayList<Class>();

        //テスト用の例外を設定
        exceptionList.add(RuntimeException.class);

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new SQLException());

        //テスト結果の検証
        assertEquals(true, result);
    }
    
    /**
     * testCheckException02()<br>
     * 例外リストにある例外が発生した場合、メソッド実行結果が
     * falseとなることを確認する<br>
     * <p>
     * リスト内の例外：SQLException<br>
     * 発生したの例外：SQLException<br>
     * </p>
     * 
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException02() throws Exception{

        //例外リストのインスタンス化
        List<Class> exceptionList = new ArrayList<Class>();

        //テスト用の例外を設定
        exceptionList.add(SQLException.class);

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new SQLException());

        //テスト結果の検証
        assertEquals(false, result);
    }

    /**
     * testCheckException03()<br>
     * 例外リストにある例外のサブクラスが発生した場合、
     * メソッド実行結果がfalseとなることを確認する<br>
     * <p>
     * リスト内の例外：Exception<br>
     * 発生したの例外：SQLException<br>
     * </p>
     * 
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException03() throws Exception{

        //例外リストのインスタンス化
        List<Class> exceptionList = new ArrayList<Class>();

        //テスト用の例外を設定
        exceptionList.add(Exception.class);

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new SQLException());

        //テスト結果の検証
        assertEquals(false, result);
    }

    /**
     * testCheckException04()<br>
     * 例外リストにある例外のサブクラスが発生した場合、
     * メソッド実行結果がfalseとなることを確認する<br>
     * <p>
     * リスト内の例外：Exception<br>
     * 発生したの例外：RuntimeException<br>
     * </p>
     * 
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException04() throws Exception{

        //例外リストのインスタンス化
        List<Class> exceptionList = new ArrayList<Class>();

        //テスト用の例外を設定
        exceptionList.add(Exception.class);

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new RuntimeException());

        //テスト結果の検証
        assertEquals(false, result);
    }
    
    /**
     * testCheckException05()<br>
     * 例外リスト（複数）にない例外が発生した場合、
     * メソッド実行結果がtrueとなることを確認する<br>
     * <p>
     * リスト内の例外：SQLException, RuntimeException<br>
     * 発生したの例外：Exception<br>
     * </p>
     * 
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException05() throws Exception{

        //例外リストのインスタンス化
        List<Class> exceptionList = new ArrayList<Class>();

        //テスト用の例外を設定
        exceptionList.add(SQLException.class);
        exceptionList.add(RuntimeException.class);

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new Exception());

        //テスト結果の検証
        assertEquals(true, result);
    }    
    
    /**
     * testCheckException06()<br>
     * 例外リスト（複数）にある例外が発生した場合、
     * メソッド実行結果がfalseとなることを確認する<br>
     * <p>
     * リスト内の例外：SQLException, RuntimeException<br>
     * 発生したの例外：RuntimeException<br>
     * </p>
     * 
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException06() throws Exception{

        //例外リストのインスタンス化
        List<Class> exceptionList = new ArrayList<Class>();

        //テスト用の例外を設定
        exceptionList.add(SQLException.class);
        exceptionList.add(RuntimeException.class);

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new RuntimeException());

        //テスト結果の検証
        assertEquals(false, result);
    }        

    /**
     * testCheckException07()<br>
     * 例外リスト（複数）にある例外のサブクラスが発生した場合、
     * メソッド実行結果がfalseとなることを確認する<br>
     * <p>
     * リスト内の例外：SQLException, RuntimeException<br>
     * 発生したの例外：ArithmeticException<br>
     * </p>
     * 
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException07() throws Exception{

        //例外リストのインスタンス化
        List<Class> exceptionList = new ArrayList<Class>();

        //テスト用の例外を設定
        exceptionList.add(SQLException.class);
        exceptionList.add(RuntimeException.class);

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new ArithmeticException());

        //テスト結果の検証
        assertEquals(false, result);
    }        
    

    /**
     * testCheckException08()<br>
     * 例外リストに何も設定されず、例外が発生した場合、
     * メソッド実行結果がtrueとなることを確認する<br>
     * <p>
     * リスト内の例外：<br>
     * 発生したの例外：RuntimeException<br>
     * </p>
     * 
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException08() throws Exception{

        //例外リストのインスタンス化
        List<Class> exceptionList = new ArrayList<Class>();

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new RuntimeException());

        //テスト結果の検証
        assertEquals(true, result);
    }        

    /**
     * testCheckException09()<br>
     * 例外リストが初期値のnullであり、例外が発生した場合、
     * メソッド実行結果がtrueとなることを確認する<br>
     * <p>
     * リスト内の例外：null<br>
     * 発生したの例外：RuntimeException<br>
     * </p>
     * 
     * @throws Exception テスト内部にtry-catchを書かないために記述
     */
    @Test
    public void testCheckException09() throws Exception{

        //例外リストのインスタンス化
        List<Class> exceptionList = null;

        //テスト対象クラスをインスタンス化
        BLogicLogInterceptor target = new BLogicLogInterceptor();

        //テスト対象クラスを実行
        target.setNoErrorLogExceptionLists(exceptionList);
        boolean result = target.checkException(new RuntimeException());

        //テスト結果の検証
        assertEquals(true, result);
    }        

    
}
