/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.terasoluna.fw.web.thin.LimitedLock;
import jp.terasoluna.fw.web.thin.SessionLockReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SessionLockControlFilter
implements Filter {
    private static final Log log = LogFactory.getLog(SessionLockControlFilter.class);
    private static final String INIT_PARAM_INTERRUPT_RESPONSE_CODE = "interruptResponseCode";
    private static final String INIT_PARAM_THRESHOLD = "threshold";
    private static final int DEFAULT_INTERRUPT_RESPONSE_CODE = 503;
    private static final int DEFAULT_THRESHOLD = 2;
    private int interruptResponseCode = 503;
    protected int threshold = 2;
    private ReferenceQueue<LimitedLock> sessionLockRefQueue = new ReferenceQueue();
    private ConcurrentHashMap<String, SessionLockReference> limitedLockMap = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpSession session = ((HttpServletRequest)req).getSession(false);
        if (session != null) {
            if (this.threshold < 0) {
                log.debug((Object)"use synchronized lock.");
                String string = session.getId().intern();
                synchronized (string) {
                    chain.doFilter(req, res);
                    return;
                }
            }
            SessionLockReference oldRef = null;
            while ((oldRef = (SessionLockReference)this.sessionLockRefQueue.poll()) != null) {
                String string = oldRef.getSessionId().intern();
                synchronized (string) {
                    if (oldRef == this.limitedLockMap.get(oldRef.getSessionId())) {
                        this.limitedLockMap.remove(oldRef.getSessionId());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LimitedLock is deallocated. sessionId = " + oldRef.getSessionId() + ", SessionLockReference = " + oldRef));
                    }
                }
            }
            LimitedLock lock = null;
            String string = session.getId().intern();
            synchronized (string) {
                SessionLockReference sessionLockRef = this.limitedLockMap.get(session.getId());
                if (sessionLockRef != null) {
                    lock = (LimitedLock)sessionLockRef.get();
                }
                if (lock == null) {
                    lock = this.createLimitedLock();
                    sessionLockRef = new SessionLockReference(session.getId(), lock, this.sessionLockRefQueue);
                    this.limitedLockMap.put(session.getId(), sessionLockRef);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("LimitedLock is allocated. sessionId = " + session.getId() + ", " + INIT_PARAM_THRESHOLD + " = " + this.threshold + ", SessionLockReference = " + sessionLockRef));
                    }
                }
            }
            try {
                log.debug((Object)"use LimitedLock.");
                this.lockLimitedLock((HttpServletRequest)req, lock);
                chain.doFilter(req, res);
                return;
            }
            catch (InterruptedException e) {
                log.info((Object)"interrupt wait for lock.");
                if (this.interruptResponseCode < 0) return;
                ((HttpServletResponse)res).sendError(this.interruptResponseCode);
                return;
            }
            finally {
                this.unlockLimitedLock((HttpServletRequest)req, lock);
            }
        }
        log.debug((Object)"not lock.");
        chain.doFilter(req, res);
    }

    protected LimitedLock createLimitedLock() {
        return new LimitedLock(this.threshold);
    }

    protected void lockLimitedLock(HttpServletRequest request, LimitedLock lock) throws InterruptedException {
        lock.lockInterruptibly();
    }

    protected void unlockLimitedLock(HttpServletRequest request, LimitedLock lock) {
        lock.unlock();
    }

    public void init(FilterConfig config) throws ServletException {
        String thresholdStr;
        String interruptResponseCodeStr = config.getInitParameter(INIT_PARAM_INTERRUPT_RESPONSE_CODE);
        if (interruptResponseCodeStr != null) {
            this.interruptResponseCode = Integer.parseInt(interruptResponseCodeStr);
        }
        if ((thresholdStr = config.getInitParameter(INIT_PARAM_THRESHOLD)) != null) {
            this.threshold = Integer.parseInt(thresholdStr);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("interruptResponseCode = " + this.interruptResponseCode + "."));
            if (this.threshold >= 0) {
                log.debug((Object)("threshold = " + this.threshold + ". LimitedLock is enabled."));
            } else {
                log.debug((Object)("threshold = " + this.threshold + ". LimitedLock is disabled. Reason: " + INIT_PARAM_THRESHOLD + " is negative number."));
            }
        }
    }

    public void destroy() {
    }
}

