/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.db;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jp.terasoluna.fw.collector.db.DBCollector;
import jp.terasoluna.fw.collector.db.QueueingDataRowHandler;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.logger.TLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueingDataRowHandlerImpl
implements QueueingDataRowHandler {
    private static final TLogger LOGGER = TLogger.getLogger(QueueingDataRowHandlerImpl.class);
    protected static AtomicBoolean verboseLog = new AtomicBoolean(false);
    protected boolean interrupted = false;
    protected Object prevRow = null;
    protected DBCollector<?> dbCollector = null;
    protected AtomicLong dataCount = new AtomicLong(0L);

    public void handleRow(Object valueObject) {
        if (!this.interrupted) {
            this.delayCollect();
            this.prevRow = valueObject;
        } else if (verboseLog.get()) {
            LOGGER.trace("TAL041003");
        }
    }

    @Override
    public void delayCollect() {
        if (this.prevRow != null) {
            if (!this.interrupted) {
                long dtcnt = this.dataCount.incrementAndGet();
                try {
                    if (this.dbCollector != null) {
                        this.dbCollector.addQueue(new DataValueObject(this.prevRow, dtcnt));
                    }
                }
                catch (InterruptedException e) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("TAL041002", new Object[]{Thread.currentThread().getName()});
                    }
                    this.interrupted = true;
                }
            } else if (verboseLog.get()) {
                LOGGER.trace("TAL041003");
            }
        }
    }

    @Override
    public void setDbCollector(DBCollector<?> dbCollector) {
        this.dbCollector = dbCollector;
    }

    public static void setVerbose(boolean verbose) {
        verboseLog.set(verbose);
    }
}

