/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.message;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import jp.terasoluna.fw.message.DefaultMessageFormatter;
import jp.terasoluna.fw.message.MessageFormatter;
import jp.terasoluna.fw.message.execption.MessageRuntimeException;

public class MessageManager {
    protected final List<String> basenames = new CopyOnWriteArrayList<String>();
    protected String messageIdFormat = "[%s] ";
    protected boolean throwIfResourceNotFound = false;
    protected final MessageFormatter messageFormatter;
    protected static final String DEFAULT_MESSAGE_ID_FORMAT_KEY = "message.id.format";
    protected static final String DEFAULT_MESSAGE_BASE_NAME_KEY = "message.basename";
    protected static final String DEFAULT_THROW_IF_RESOURCE_NOT_FOUND_KEY = "throw.if.resource.not.found";
    protected static final String DEFAULT_MESSAGE_FORMATTER_FQCN_KEY = "message.formatter.fqcn";

    protected static ClassLoader getClassLoader() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (contextClassLoader != null) {
            return contextClassLoader;
        }
        ClassLoader thisClassLoader = MessageManager.class.getClassLoader();
        return thisClassLoader;
    }

    public MessageManager(String configFile) {
        this(configFile, DEFAULT_MESSAGE_ID_FORMAT_KEY, DEFAULT_MESSAGE_BASE_NAME_KEY, DEFAULT_THROW_IF_RESOURCE_NOT_FOUND_KEY, DEFAULT_MESSAGE_FORMATTER_FQCN_KEY);
    }

    public MessageManager(String configFile, String messageIdFormatKey, String messageBaseNameKey, String throwIfResourceNotFoundKey, String messageFormatterFqcnKey) {
        try {
            ClassLoader cl = MessageManager.getClassLoader();
            String format = null;
            String throwIfNotFound = null;
            String messageFormatterFqcn = null;
            InputStream strm = cl.getResourceAsStream(configFile);
            if (strm != null) {
                Properties p = new Properties();
                p.load(strm);
                format = p.getProperty(messageIdFormatKey);
                throwIfNotFound = p.getProperty(throwIfResourceNotFoundKey);
                messageFormatterFqcn = p.getProperty(messageFormatterFqcnKey);
            }
            if (format != null) {
                this.messageIdFormat = format;
            }
            if (throwIfNotFound != null) {
                this.throwIfResourceNotFound = Boolean.parseBoolean(throwIfNotFound);
            }
            if (messageFormatterFqcn != null) {
                try {
                    Class<?> clazz = Class.forName(messageFormatterFqcn, true, cl);
                    this.messageFormatter = (MessageFormatter)clazz.newInstance();
                }
                catch (Exception e) {
                    StringBuilder sb = new StringBuilder("MessageFormatter[").append(messageFormatterFqcn).append("] is not found.");
                    throw new MessageRuntimeException(sb.toString(), e);
                }
            } else {
                this.messageFormatter = new DefaultMessageFormatter();
            }
            Enumeration<URL> urls = cl.getResources(configFile);
            while (urls.hasMoreElements()) {
                String[] basenameArray;
                URL url = urls.nextElement();
                if (url == null) continue;
                Properties p = new Properties();
                strm = url.openStream();
                p.load(strm);
                if (!p.containsKey(messageBaseNameKey)) continue;
                for (String s : basenameArray = p.getProperty(messageBaseNameKey).split(",")) {
                    String basename = s.trim();
                    if ("".equals(basename)) continue;
                    this.basenames.add(basename);
                }
            }
        }
        catch (MessageRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageRuntimeException(e);
        }
    }

    protected ResourceBundle getResourceBundle(String basename, Locale locale) {
        ResourceBundle bundle;
        block3: {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            bundle = null;
            try {
                bundle = ResourceBundle.getBundle(basename, locale);
            }
            catch (MissingResourceException e) {
                if (!this.throwIfResourceNotFound) break block3;
                StringBuilder sb = new StringBuilder("resource[").append(basename).append("] is not found");
                throw new MessageRuntimeException(sb.toString(), e);
            }
        }
        return bundle;
    }

    protected String getStringOrNull(ResourceBundle bundle, String key) {
        if (bundle == null) {
            return null;
        }
        if (key == null) {
            if (this.throwIfResourceNotFound) {
                throw new MessageRuntimeException("key is null");
            }
            return null;
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    protected String getMessagePattern(String messageId, Locale locale) {
        String basename;
        ResourceBundle bundle;
        String message = null;
        Iterator<String> i$ = this.basenames.iterator();
        while (i$.hasNext() && (message = this.getStringOrNull(bundle = this.getResourceBundle(basename = i$.next(), locale), messageId)) == null) {
        }
        if (message == null && this.throwIfResourceNotFound) {
            StringBuilder sb = new StringBuilder("key[").append(messageId).append("] is not found");
            throw new MessageRuntimeException(sb.toString());
        }
        return message;
    }

    public String getMessage(boolean resource, String messageIdOrPattern, Object ... args) throws MessageRuntimeException {
        return this.getMessage(resource, messageIdOrPattern, null, args);
    }

    public String getMessage(boolean resource, String messageIdOrPattern, Locale locale, Object ... args) throws MessageRuntimeException {
        String pattern = null;
        StringBuilder message = new StringBuilder();
        if (resource) {
            pattern = this.getMessagePattern(messageIdOrPattern, locale);
            message.append(String.format(this.messageIdFormat, messageIdOrPattern));
        } else {
            pattern = messageIdOrPattern;
        }
        if (pattern != null) {
            try {
                String body = this.messageFormatter.format(pattern, args);
                message.append(body);
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder("message pattern is illeagal. pattern=").append(pattern).append("]");
                if (resource) {
                    sb.append(" logId=");
                    sb.append(messageIdOrPattern);
                }
                throw new MessageRuntimeException(sb.toString(), e);
            }
        }
        return message.toString();
    }
}

