/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.utlib;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.action.DynaActionFormClass;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;
import org.xml.sax.SAXException;

/**
 * DynaActionForm𐶐郆[eBeBNX
 *
 */
public class DynaActionFormCreator extends Object {

    private final static Log log =
        LogFactory.getLog(DynaActionFormCreator.class);

    private Digester digester;

    public DynaActionFormCreator(String rulesFilePath) {
        // create digester
        try {
            this.digester =
                DigesterLoader.createDigester(new File(rulesFilePath).toURL());
        } catch (MalformedURLException e) {
            // log error
            log.error("This file path is not found. path=" + rulesFilePath);
        }
    }

    protected DynaActionForm create(FormBeanConfig formBeanConfig)
        throws IllegalAccessException, InstantiationException {

        // create module config
        ModuleConfig moduleConfig = new ModuleConfigImpl("");

        // create action mapping
        ActionMapping actionMapping = new ActionMapping();

        /////  Action Mapping  /////
        // set form name
        actionMapping.setName(formBeanConfig.getName());
        // set module config
        actionMapping.setModuleConfig(moduleConfig);

//        /////  Form Bean Config  /////
//        // set module config at form bean config
//        formBeanConfig.setModuleConfig(moduleConfig);
//
//        /////  Module Config  /////
//        // set action mapping at module config
//        moduleConfig.addFormBeanConfig(formBeanConfig);
//
//        // create DynaActionFormClass object
//        DynaActionFormClass dynaClass =
//            DynaActionFormClass.createDynaActionFormClass(formBeanConfig);

        //Add start
        DynaActionFormClass dynaClass =
            formBeanConfig.getDynaActionFormClass();
        //Add end

        // create this action form
        DynaActionForm dynaActionForm =
            (DynaActionForm) dynaClass.newInstance();

        // action form initialized
        dynaActionForm.initialize(actionMapping);

        // return
        return dynaActionForm;
    }

    public DynaActionForm create(String configFilePath) {

        // create config
        FormBeanConfig formBeanConfig = this.parse(configFilePath);

        // create bean
        DynaActionForm dynaActionForm = null;
        try {
            dynaActionForm = this.create(formBeanConfig);
        } catch (IllegalAccessException e) {
            // log errror
            log.error("", e);
            return null;
        } catch (InstantiationException e) {
            // log error
            log.error("", e);
            return null;
        }

        // return
        return dynaActionForm;
    }

    public void logging(String configFilePath) {

        // create reader
        BufferedReader reader;
        try {
            reader =
                new BufferedReader(new FileReader(new File(configFilePath)));
        } catch (FileNotFoundException e) {
            // log error
            log.error("", e);
            return;
        }

        // create message
        String message = System.getProperty("line.separator");
        // create buffer
        String buffer = "";

        try {
            while ((buffer = reader.readLine()) != null) {
                message += buffer + System.getProperty("line.separator");
            }
        } catch (IOException e) {
            // log error
            log.error("", e);
            return;
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    log.error("", e);
                    //
                }
            }
        }

        // logging
        log.info(message);
    }

    public FormBeanConfig parse(String configFilePath) {
        // create config
        FormBeanConfig formBeanConfig = null;
        try {
            formBeanConfig =
                (FormBeanConfig) this.digester.parse(new File(configFilePath));
        } catch (IOException e) {
            // log error
            log.error("", e);
            return null;
        } catch (SAXException e) {
            // log error
            log.error("", e);
            return null;
        }
        // return
        return formBeanConfig;
    }

}
