package jp.terasoluna.fw.collector.file;

import java.net.URL;
import java.util.List;

import jp.terasoluna.fw.collector.Collector;
import jp.terasoluna.fw.collector.db.UserBean;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.util.MemoryInfo;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.ex.unit.testcase.DaoTestCase;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.validation.Validator;

public class FileValidateCollector004Test extends DaoTestCase {
    /**
     * Log.
     */
    private static Log logger = LogFactory
            .getLog(FileValidateCollector004Test.class);

    private FileQueryDAO csvFileQueryDAO = null;

    public void setCsvFileQueryDAO(FileQueryDAO csvFileQueryDAO) {
        this.csvFileQueryDAO = csvFileQueryDAO;
    }

    @Override
    protected void onSetUp() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        super.onSetUp();
    }

    @Override
    protected void onTearDown() throws Exception {
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        System.gc();
        if (logger.isInfoEnabled()) {
            logger.info(MemoryInfo.getMemoryInfo());
        }
        super.onTearDown();
    }

    @Override
    protected void addConfigLocations(List<String> configLocations) {
        configLocations.add("jp/terasoluna/fw/collector/db/dataSource.xml");
    }

    /**
     * testFileCollector004
     * @throws Exception
     */
    public void testFileCollector004() throws Exception {
        if (this.csvFileQueryDAO == null) {
            fail("csvFileQueryDAOnullłB");
        }

        URL url = getClass().getClassLoader().getResource("USER_TEST.csv");
        if (logger.isDebugEnabled()) {
            if (url != null) {
                logger.debug("url.getPath() : " + url.getPath());
            } else {
                logger.debug("url.getPath() : " + null);
            }
        }

        if (url == null) {
            fail("urlnullłB");
        }

        // int count_first = 0;
        CollectorExceptionHandler exceptionHandler = new CollectorExceptionHandlerStub();
        Validator validator = new ValidatorStub();
        ValidationErrorHandler validationErrorHandler = null;

        Collector<B000001Data> it = new FileValidateCollector<B000001Data>(
                this.csvFileQueryDAO, url.getPath(), B000001Data.class,
                exceptionHandler, validator, validationErrorHandler);

        it.close();
    }

    /**
     * testFileValidateCollector005
     * @throws Exception
     */
    @SuppressWarnings("unchecked")
    public void testFileValidateCollector005() throws Exception {
        FileCollectorConfig config = null;

        @SuppressWarnings("unused")
        FileValidateCollector<UserBean> dbc = null;
        try {
            dbc = new FileValidateCollector<UserBean>(config);
            fail("s");
        } catch (IllegalArgumentException e) {
            assertNotNull(e);
            assertEquals("The parameter is null.", e.getMessage());
        }
    }

    /**
     * testFileCollector006
     * @throws Exception
     */
    public void testFileCollector006() throws Exception {
        if (this.csvFileQueryDAO == null) {
            fail("csvFileQueryDAOnullłB");
        }

        URL url = getClass().getClassLoader().getResource("USER_TEST.csv");
        if (logger.isDebugEnabled()) {
            if (url != null) {
                logger.debug("url.getPath() : " + url.getPath());
            } else {
                logger.debug("url.getPath() : " + null);
            }
        }

        if (url == null) {
            fail("urlnullłB");
        }

        // int count_first = 0;
        CollectorExceptionHandler exceptionHandler = new CollectorExceptionHandlerStub();
        Validator validator = new ValidatorStub();
        ValidationErrorHandler validationErrorHandler = null;
        int queueSize = 123;

        Collector<B000001Data> it = new FileValidateCollector<B000001Data>(
                this.csvFileQueryDAO, url.getPath(), B000001Data.class,
                queueSize, exceptionHandler, validator, validationErrorHandler);

        it.close();
    }

}
