package jp.terasoluna.fw.collector;

import static org.junit.Assert.*;
import jp.terasoluna.fw.exception.SystemException;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class AbstractCollectorTest2 {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        AbstractCollector.setVerbose(true);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        AbstractCollector.setVerbose(false);
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * 
     */
    @Test
    public void testExecute001() {
        AbstractCollectorStubHasNext1<AbstractCollectorTestBean> col = new AbstractCollectorStubHasNext1<AbstractCollectorTestBean>();

        // eXg
        try {
            col.execute();
        } catch (SystemException e) {
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            return;
        }

        fail();
        return;
    }

    /**
     * 
     */
    @Test
    public void testHasNext001() {
        AbstractCollectorStubHasNext2<AbstractCollectorTestBean> col = new AbstractCollectorStubHasNext2<AbstractCollectorTestBean>();

        // eXg
        boolean result = col.hasNext();

        assertFalse(result);
    }

    /**
     * 
     */
    @Test
    public void testHasNext002() {
        AbstractCollectorStubHasNext3<AbstractCollectorTestBean> col = new AbstractCollectorStubHasNext3<AbstractCollectorTestBean>();

        // eXg
        boolean result = col.hasNext();

        assertFalse(result);
    }

    /**
     * 
     */
    @Test
    public void testHasNext003() {
        AbstractCollectorStubHasNext3<AbstractCollectorTestBean> col = new AbstractCollectorStubHasNext3<AbstractCollectorTestBean>();

        // eXg
        boolean result = col.hasNext();

        assertFalse(result);
    }

    /**
     * 
     */
    @Test
    public void testHasNext004() {
        AbstractCollectorStubHasNext4<AbstractCollectorTestBean> col = new AbstractCollectorStubHasNext4<AbstractCollectorTestBean>();

        // eXg
        boolean result = col.hasNext();

        assertFalse(result);
    }

    /**
     * 
     */
    @Test
    public void testNext001() {
        AbstractCollectorStubNext1<AbstractCollectorTestBean> col = new AbstractCollectorStubNext1<AbstractCollectorTestBean>();

        AbstractCollectorTestBean result = col.next();

        assertNull(result);
    }

    /**
     * 
     */
    @Test
    public void testNext002() {
        AbstractCollectorStubNext2<AbstractCollectorTestBean> col = new AbstractCollectorStubNext2<AbstractCollectorTestBean>();

        @SuppressWarnings("unused")
        AbstractCollectorTestBean result = null;
        try {
            result = col.next();
        } catch (Exception e) {
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            assertEquals(Exception.class, e.getCause().getClass());
            assertEquals(null, e.getCause().getMessage());
            return;
        }

        fail();
    }

    /**
     * 
     */
    @Test
    public void testNext003() {
        AbstractCollectorStubNext3<AbstractCollectorTestBean> col = new AbstractCollectorStubNext3<AbstractCollectorTestBean>();

        @SuppressWarnings("unused")
        AbstractCollectorTestBean result = null;
        try {
            result = col.next();
        } catch (Exception e) {
            assertNotNull(e);
            assertEquals(SystemException.class, e.getClass());
            assertEquals(Exception.class, e.getCause().getClass());
            assertEquals("hoge", e.getCause().getMessage());
            return;
        }

        fail();
    }

    /**
     * 
     */
    @Test
    public void testNext004() {
        AbstractCollectorStubNext4<AbstractCollectorTestBean> col = new AbstractCollectorStubNext4<AbstractCollectorTestBean>();
        col.exceptionHandler = new CollectorExceptionHandlerStub1();

        AbstractCollectorTestBean result = null;

        result = col.next();

        assertNull(result);
    }

    /**
     * 
     */
    @Test
    public void testGetNext() {
        AbstractCollectorStubGetNext1<AbstractCollectorTestBean> col = new AbstractCollectorStubGetNext1<AbstractCollectorTestBean>();
        col.exceptionHandler = new CollectorExceptionHandlerStub1();

        AbstractCollectorTestBean result = null;

        result = col.getNext();

        assertNull(result);
    }

    /**
     * testFinalize
     * @throws Throwable
     */
    @Test
    public void testFinalize() throws Throwable {
        AbstractCollectorStubGetNext1<AbstractCollectorTestBean> col = new AbstractCollectorStubGetNext1<AbstractCollectorTestBean>();

        col.finalize();
    }

    // @Test
    // public void testGetPrevious() {
    // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testGetCurrent() {
    // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testClose() {
    // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testRemove() {
    // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testIterator() {
    // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testSetQueueSize() {
    // // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testGetSleepWait() {
    // // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testSetSleepWait() {
    // // fail("܂Ă܂");
    // }
    //
    // @Test
    // public void testCloseQuietly() {
    // // fail("܂Ă܂");
    // }

}
