package jp.terasoluna.fw.collector;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

import jp.terasoluna.fw.collector.db.ValidatorStub;
import jp.terasoluna.fw.collector.validate.ValidateErrorStatus;
import jp.terasoluna.fw.collector.validate.ValidationErrorException;
import jp.terasoluna.fw.collector.vo.DataValueObject;

public class AbstractCollectorStub17<P> extends AbstractCollector<P> {

    public AbstractCollectorStub17() {

        this.validator = new ValidatorStub();

    }

    @Override
    protected ValidateErrorStatus validate(DataValueObject dataValueObject) {
        throw new ValidationErrorException();
    }

    @Override
    protected Queue<DataValueObject> createQueue() {
        if (this.currentQueue == null) {
            // currentL[
            this.currentQueue = createCurrentQueue();
        }
        if (this.previousQueue == null) {
            // previousL[
            this.previousQueue = createPreviousQueue();
        }
        return new ConcurrentLinkedQueue<DataValueObject>();
    }

    public Integer call() throws Exception {
        Thread.sleep(1000);
        return null;
    }

    @Override
    protected boolean isFinish() {
        return false;
    }
}
