/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.Channel;

import jp.terasoluna.fw.ex.unit.util.AssertUtils;
import jp.terasoluna.fw.ex.unit.util.ReflectionUtils;
import jp.terasoluna.fw.file.dao.FileException;
import junit.framework.TestCase;

/**
 * OFeeXg\bhƂ̑OmF邱
 */
public class FastFileUtilityTest extends TestCase {
    /**
     * testConstructor
     */
    public void testConstructor() {
        // JobW𖞂߂̍
        ReflectionUtils.newInstance(FastFileUtility.class);
        assertTrue(true);
    }

    /**
     * testCopyFile01()<br>
     * <br>
     * OԁFNXpX/testdata ztest01.txt݂邱ƁB<br>
     * <br>
     * eXgTvFt@Cǂݍ܂AɃRs[邱ƂmFB<br>
     * <br>
     * mFځFRs[̃t@CRs[ƓemFB<br>
     * <br>
     * @throws Exception
     */
    public void testCopyFile01() throws Exception {

        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String srcFile = srcUrl.getPath();
        String newFile = srcFile.replaceAll("01", "01A");
        File newFileCheck = new File(newFile);
        if (newFileCheck.exists()) {
            newFileCheck.delete();
        }

        // eXg{
        FastFileUtility.copyFile(srcFile, newFile);

        // ʌ
        File expected = new File(srcFile);
        File actual = new File(newFile);

        AssertUtils.assertFileEquals(expected, actual);
    }

    /**
     * testCopyFile02()<br>
     * <br>
     * OԁFNXpX/testdata ztest01.txt݂邱ƁB<br>
     * OԁFNXpX/testdata ztest02.txt݂ȂƁB<br>
     * <br>
     * eXgTvFt@Cǂݍ܂ꂸAFileExceptionX[邱ƂmFB<br>
     * <br>
     * mFځFFileExceptionX[邱ƁB<br>
     * <br>
     * mFځFOɁuC:\\tmp\\test02.txt is not exist.vbZ[Wݒ肳Ă邱ƁB<br>
     * <br>
     * @throws Exception
     */
    public void testCopyFile02() throws Exception {

        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String srcFile = srcUrl.getPath().replaceAll("01", "02");
        String newFile = srcFile.replaceAll("02", "02A");

        try {
            FastFileUtility.copyFile(srcFile, newFile);
            fail();
        } catch (FileException e) {
            assertTrue(e.getMessage().endsWith("test02.txt is not exist."));
        }
    }

    /**
     * testCopyFile03()<br>
     * <br>
     * OԁFNXpX/testdata ztest03.txt݂Aǂݎ茠Ȃ<br>
     * <br>
     * eXgTvFt@Cǂݍ܂ꂸAFileExceptionX[邱ƂmFB<br>
     * <br>
     * mFځFFileExceptionX[邱ƁB<br>
     * <br>
     * mFځFOɁuFile control operation was failed.vbZ[Wݒ肳Ă邱ƁB<br>
     * <br>
     * @throws Exception
     */
    public void testCopyFile03() throws Exception {

        URL srcUrl = this.getClass().getResource("/testdata/test03.txt");
        String srcFile = srcUrl.getPath();
        String newFile = srcFile.replaceAll("03", "03A");

        try {
            FastFileUtility.copyFile(srcFile, newFile);
            fail();
        } catch (FileException e) {
            assertEquals("File control operation was failed.", e.getMessage());
        }
    }

    /**
     * testCopyFile04()<br>
     * <br>
     * OԁFNXpX/testdata ztest01.txt݂邱ƁB<br>
     * <br>
     * eXgTvFsrcFilenullݒ肵ꍇAt@Cǂݍ܂ꂸAFileExceptionX[邱ƂmFB<br>
     * <br>
     * mFځFFileExceptionX[邱ƁB<br>
     * <br>
     * mFځFOɁuFile control operation was failed.vbZ[Wݒ肳Ă邱ƁB<br>
     * <br>
     * @throws Exception
     */
    public void testCopyFile04() throws Exception {

        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String srcFile = null;
        String newFile = srcUrl.getPath().replaceAll("01", "04A");

        try {
            FastFileUtility.copyFile(srcFile, newFile);
            fail();
        } catch (FileException e) {
        }
    }

    /**
     * testCopyFile05()<br>
     * <br>
     * OԁFȂ<br>
     * <br>
     * eXgTvFNXpX/testdata ztest01.txt݂AnewFilenullݒ肳ꂽꍇA FileExceptionX[邱ƂmFB<br>
     * <br>
     * mFځFFileExceptionX[邱ƁB<br>
     * <br>
     * mFځFOɁuFile control operation was failed.vbZ[Wݒ肳Ă邱ƁB<br>
     * <br>
     * @throws Exception
     */
    public void testCopyFile05() throws Exception {

        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String srcFile = srcUrl.getPath();
        String newFile = null;

        try {
            FastFileUtility.copyFile(srcFile, newFile);
            fail();
        } catch (FileException e) {
        }
    }

    /**
     * testCopyFile06()<br>
     * <br>
     * OԁFNXpX/testdata zɗeʂ̑傫test06.txt邱<br>
     * <br>
     * eXgTvFt@Cǂݍ܂AɃRs[邱ƂmFB<br>
     * <br>
     * mFځFRs[̃t@CRs[ƓemFB<br>
     * <br>
     * @throws Exception
     */
    public void testCopyFile06() throws Exception {

        // eXgf[^ݒ
        URL srcUrl = this.getClass().getResource("/testdata/test06.txt");
        String srcFile = srcUrl.getPath();
        String newFile = srcFile.replaceAll("06", "06A");
        File newFileCheck = new File(newFile);
        if (newFileCheck.exists()) {
            newFileCheck.delete();
        }

        // eXg{
        FastFileUtility.copyFile(srcFile, newFile);

        // ʌ
        File expected = new File(srcFile);
        File actual = new File(newFile);

        AssertUtils.assertFileEquals(expected, actual);

    }

    /**
     * testCloseQuietly001
     * @throws Exception
     */
    public void testCloseQuietly001() throws Exception {
        Channel channel = new Channel() {
            public void close() throws IOException {
            }

            public boolean isOpen() {
                return false;
            }
        };

        // eXg
        FastFileUtility.closeQuietly(channel);
    }

    /**
     * testCloseQuietly002
     * @throws Exception
     */
    public void testCloseQuietly002() throws Exception {
        Channel channel = new Channel() {
            public void close() throws IOException {
                throw new IOException();
            }

            public boolean isOpen() {
                return false;
            }
        };

        // eXg
        FastFileUtility.closeQuietly(channel);
    }

    /**
     * testCloseQuietly011
     * @throws Exception
     */
    public void testCloseQuietly011() throws Exception {
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        FileInputStream channel = new FileInputStream(srcUrl.getPath());

        // eXg
        FastFileUtility.closeQuietly(channel);
    }

    /**
     * testCloseQuietly012
     * @throws Exception
     */
    public void testCloseQuietly012() throws Exception {
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        FileInputStream channel = new FileInputStream(srcUrl.getPath()) {
            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };

        // eXg
        FastFileUtility.closeQuietly(channel);
    }

    /**
     * testCloseQuietly021
     * @throws Exception
     */
    public void testCloseQuietly021() throws Exception {
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String srcFile = srcUrl.getPath();
        String newFile = srcFile.replaceAll("01", "01A");
        File newFileCheck = new File(newFile);
        if (newFileCheck.exists()) {
            newFileCheck.delete();
        }

        FileOutputStream channel = new FileOutputStream(newFile);

        // eXg
        FastFileUtility.closeQuietly(channel);
    }

    /**
     * testCloseQuietly022
     * @throws Exception
     */
    public void testCloseQuietly022() throws Exception {
        URL srcUrl = this.getClass().getResource("/testdata/test01.txt");
        String srcFile = srcUrl.getPath();
        String newFile = srcFile.replaceAll("01", "01A");
        File newFileCheck = new File(newFile);
        if (newFileCheck.exists()) {
            newFileCheck.delete();
        }

        FileOutputStream channel = new FileOutputStream(newFile) {
            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };

        // eXg
        FastFileUtility.closeQuietly(channel);
    }

}
