/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector.db;

import jp.terasoluna.fw.collector.AbstractCollectorConfig;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;

import org.springframework.validation.Validator;

/**
 * DBCollectorݒ荀
 */
public class DBCollectorConfig extends AbstractCollectorConfig {

    /** QueryRowHandleDAO */
    protected QueryRowHandleDAO queryRowHandleDAO = null;

    /** sSQLID */
    protected String sqlID = null;

    /** SQLɃoChli[IuWFNg */
    protected Object bindParams = null;

    /** 1:N}bsOgptOigptruej */
    protected boolean relation1n = false;

    /** DBCollectorO */
    protected DBCollectorPreprocess dbCollectorPreprocess = null;

    /** DBCollector㏈ */
    protected DBCollectorPostprocess dbCollectorPostprocess = null;

    /**
     * RXgN^
     * @param queryRowHandleDAO QueryRowHandleDAOCX^X
     * @param sqlID sSQLID
     * @param bindParams SQLɃoChli[IuWFNg
     */
    public DBCollectorConfig(QueryRowHandleDAO queryRowHandleDAO, String sqlID,
            Object bindParams) {
        this.queryRowHandleDAO = queryRowHandleDAO;
        this.sqlID = sqlID;
        this.bindParams = bindParams;
    }

    /**
     * L[TCYݒ肷
     * @param queueSize L[TCY
     * @return DBCollectorConfig
     */
    public DBCollectorConfig addQueueSize(int queueSize) {
        this.setQueueSize(queueSize);
        return this;
    }

    /**
     * CollectorExceptionHandlerݒ肷
     * @param exceptionHandler CollectorExceptionHandler
     * @return DBCollectorConfig
     */
    public DBCollectorConfig addExceptionHandler(
            CollectorExceptionHandler exceptionHandler) {
        this.setExceptionHandler(exceptionHandler);
        return this;
    }

    /**
     * Validatorݒ肷
     * @param validator Validator
     * @return DBCollectorConfig
     */
    public DBCollectorConfig addValidator(Validator validator) {
        this.setValidator(validator);
        return this;
    }

    /**
     * ValidationErrorHandlerݒ肷
     * @param validationErrorHandler ValidationErrorHandler
     * @return DBCollectorConfig
     */
    public DBCollectorConfig addValidationErrorHandler(
            ValidationErrorHandler validationErrorHandler) {
        this.setValidationErrorHandler(validationErrorHandler);
        return this;
    }

    /**
     * 1:N}bsOgptOݒ肷
     * @param relation1n 1:N}bsOgptO
     * @return DBCollectorConfig
     */
    public DBCollectorConfig addRelation1n(boolean relation1n) {
        this.setRelation1n(relation1n);
        return this;
    }

    /**
     * DBCollectorOݒ肷
     * @param dbCollectorPreprocess DBCollectorO
     * @return DBCollectorConfig
     */
    public DBCollectorConfig addDBCollectorPreprocess(
            DBCollectorPreprocess dbCollectorPreprocess) {
        this.setDbCollectorPreprocess(dbCollectorPreprocess);
        return this;
    }

    /**
     * DBCollector㏈ݒ肷
     * @param dbCollectorPostprocess DBCollector㏈
     * @return DBCollectorConfig
     */
    public DBCollectorConfig addDBCollectorPostprocess(
            DBCollectorPostprocess dbCollectorPostprocess) {
        this.setDbCollectorPostprocess(dbCollectorPostprocess);
        return this;
    }

    /**
     * RXgN^ŏstOݒ肷
     * @param executeByConstructor RXgN^ŏstO
     * @return DBCollectorConfig
     */
    public DBCollectorConfig addExecuteByConstructor(
            boolean executeByConstructor) {
        this.setExecuteByConstructor(executeByConstructor);
        return this;
    }

    /**
     * QueryRowHandleDAO擾B
     * @return QueryRowHandleDAO
     */
    public QueryRowHandleDAO getQueryRowHandleDAO() {
        return queryRowHandleDAO;
    }

    /**
     * QueryRowHandleDAOݒ肷B
     * @param queryRowHandleDAO QueryRowHandleDAO
     */
    public void setQueryRowHandleDAO(QueryRowHandleDAO queryRowHandleDAO) {
        this.queryRowHandleDAO = queryRowHandleDAO;
    }

    /**
     * sSQLID擾B
     * @return sSQLID
     */
    public String getSqlID() {
        return sqlID;
    }

    /**
     * sSQLIDݒ肷B
     * @param sqlID sSQLID
     */
    public void setSqlID(String sqlID) {
        this.sqlID = sqlID;
    }

    /**
     * SQLɃoChli[IuWFNg擾B
     * @return SQLɃoChli[IuWFNg
     */
    public Object getBindParams() {
        return bindParams;
    }

    /**
     * SQLɃoChli[IuWFNgݒ肷B
     * @param bindParams SQLɃoChli[IuWFNg
     */
    public void setBindParams(Object bindParams) {
        this.bindParams = bindParams;
    }

    /**
     * 1:N}bsOgptO擾B
     * @return 1:N}bsOgptO
     */
    public boolean isRelation1n() {
        return relation1n;
    }

    /**
     * 1:N}bsOgptOݒ肷B
     * @param relation1n 1:N}bsOgptO
     */
    public void setRelation1n(boolean relation1n) {
        this.relation1n = relation1n;
    }

    /**
     * DBCollectorO擾B
     * @return DBCollectorO
     */
    public DBCollectorPreprocess getDbCollectorPreprocess() {
        return dbCollectorPreprocess;
    }

    /**
     * DBCollectorOݒ肷B
     * @param dbCollectorPreprocess DBCollectorO
     */
    public void setDbCollectorPreprocess(
            DBCollectorPreprocess dbCollectorPreprocess) {
        this.dbCollectorPreprocess = dbCollectorPreprocess;
    }

    /**
     * DBCollector㏈擾B
     * @return DBCollector㏈
     */
    public DBCollectorPostprocess getDbCollectorPostprocess() {
        return dbCollectorPostprocess;
    }

    /**
     * DBCollector㏈ݒ肷B
     * @param dbCollectorPostprocess DBCollector㏈
     */
    public void setDbCollectorPostprocess(
            DBCollectorPostprocess dbCollectorPostprocess) {
        this.dbCollectorPostprocess = dbCollectorPostprocess;
    }

}
