/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.db;

import jp.terasoluna.fw.collector.db.DBCollector;
import jp.terasoluna.fw.collector.db.DBCollectorConfig;
import jp.terasoluna.fw.collector.db.DBCollectorPostprocess;
import jp.terasoluna.fw.collector.db.DBCollectorPreprocess;
import jp.terasoluna.fw.collector.db.Queueing1NRelationDataRowHandlerImpl;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.validate.ExceptionValidationErrorHandler;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBValidateCollector<P>
extends DBCollector<P> {
    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, Validator validator) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addValidator(validator));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, Validator validator, ValidationErrorHandler validationErrorHandler) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addValidator(validator).addValidationErrorHandler(validationErrorHandler));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, boolean relation1n, Validator validator) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addRelation1n(relation1n).addValidator(validator));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, boolean relation1n, Validator validator, ValidationErrorHandler validationErrorHandler) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addRelation1n(relation1n).addValidator(validator).addValidationErrorHandler(validationErrorHandler));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, int queueSize, Validator validator) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addQueueSize(queueSize).addValidator(validator));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, int queueSize, Validator validator, ValidationErrorHandler validationErrorHandler) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addQueueSize(queueSize).addValidator(validator).addValidationErrorHandler(validationErrorHandler));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, int queueSize, CollectorExceptionHandler exceptionHandler, Validator validator) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addQueueSize(queueSize).addExceptionHandler(exceptionHandler).addValidator(validator));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, int queueSize, CollectorExceptionHandler exceptionHandler, Validator validator, ValidationErrorHandler validationErrorHandler) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addQueueSize(queueSize).addExceptionHandler(exceptionHandler).addValidator(validator).addValidationErrorHandler(validationErrorHandler));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, int queueSize, boolean relation1n, CollectorExceptionHandler exceptionHandler, DBCollectorPreprocess dbCollectorPreprocess, DBCollectorPostprocess dbCollectorPostprocess, Validator validator) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addQueueSize(queueSize).addRelation1n(relation1n).addExceptionHandler(exceptionHandler).addDBCollectorPreprocess(dbCollectorPreprocess).addDBCollectorPostprocess(dbCollectorPostprocess).addValidator(validator));
    }

    public DBValidateCollector(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams, int queueSize, boolean relation1n, CollectorExceptionHandler exceptionHandler, DBCollectorPreprocess dbCollectorPreprocess, DBCollectorPostprocess dbCollectorPostprocess, Validator validator, ValidationErrorHandler validationErrorHandler) {
        this(new DBCollectorConfig(queryRowHandleDAO, sqlID, bindParams).addQueueSize(queueSize).addRelation1n(relation1n).addExceptionHandler(exceptionHandler).addDBCollectorPreprocess(dbCollectorPreprocess).addDBCollectorPostprocess(dbCollectorPostprocess).addValidator(validator).addValidationErrorHandler(validationErrorHandler));
    }

    public DBValidateCollector(DBCollectorConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The parameter is null.");
        }
        this.queryRowHandleDAO = config.getQueryRowHandleDAO();
        this.sqlID = config.getSqlID();
        this.bindParams = config.getBindParams();
        if (config.getQueueSize() > 0) {
            this.setQueueSize(config.getQueueSize());
        }
        if (config.isRelation1n()) {
            this.queueingDataRowHandlerClass = Queueing1NRelationDataRowHandlerImpl.class;
        }
        this.validator = config.getValidator();
        if (config.getValidator() != null) {
            this.validationErrorHandler = config.getValidationErrorHandler() != null ? config.getValidationErrorHandler() : new ExceptionValidationErrorHandler();
        }
        this.exceptionHandler = config.getExceptionHandler();
        this.dbCollectorPreprocess = config.getDbCollectorPreprocess();
        this.dbCollectorPostprocess = config.getDbCollectorPostprocess();
        if (config.isExecuteByConstructor()) {
            this.execute();
        }
    }
}

