/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.httpinvoker;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.springframework.context.i18n.LocaleContext;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.remoting.httpinvoker.AbstractHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;
import org.springframework.remoting.support.RemoteInvocationResult;
import org.springframework.util.StringUtils;

public class SimpleHttpInvokerRequestExecutor
extends AbstractHttpInvokerRequestExecutor {
    protected RemoteInvocationResult doExecuteRequest(HttpInvokerClientConfiguration config, ByteArrayOutputStream baos) throws IOException, ClassNotFoundException {
        HttpURLConnection con = this.openConnection(config);
        this.prepareConnection(con, baos.size());
        this.writeRequestBody(config, con, baos);
        this.validateResponse(config, con);
        InputStream responseBody = this.readResponseBody(config, con);
        return this.readRemoteInvocationResult(responseBody, config.getCodebaseUrl());
    }

    protected HttpURLConnection openConnection(HttpInvokerClientConfiguration config) throws IOException {
        URLConnection con = new URL(config.getServiceUrl()).openConnection();
        if (!(con instanceof HttpURLConnection)) {
            throw new IOException("Service URL [" + config.getServiceUrl() + "] is not an HTTP URL");
        }
        return (HttpURLConnection)con;
    }

    protected void prepareConnection(HttpURLConnection con, int contentLength) throws IOException {
        con.setDoOutput(true);
        con.setRequestMethod("POST");
        con.setRequestProperty("Content-Type", this.getContentType());
        con.setRequestProperty("Content-Length", Integer.toString(contentLength));
        LocaleContext locale = LocaleContextHolder.getLocaleContext();
        if (locale != null) {
            con.setRequestProperty("Accept-Language", StringUtils.toLanguageTag(locale.getLocale()));
        }
        if (this.isAcceptGzipEncoding()) {
            con.setRequestProperty("Accept-Encoding", "gzip");
        }
    }

    protected void writeRequestBody(HttpInvokerClientConfiguration config, HttpURLConnection con, ByteArrayOutputStream baos) throws IOException {
        baos.writeTo(con.getOutputStream());
    }

    protected void validateResponse(HttpInvokerClientConfiguration config, HttpURLConnection con) throws IOException {
        if (con.getResponseCode() >= 300) {
            throw new IOException("Did not receive successful HTTP response: status code = " + con.getResponseCode() + ", status message = [" + con.getResponseMessage() + "]");
        }
    }

    protected InputStream readResponseBody(HttpInvokerClientConfiguration config, HttpURLConnection con) throws IOException {
        if (this.isGzipResponse(con)) {
            return new GZIPInputStream(con.getInputStream());
        }
        return con.getInputStream();
    }

    protected boolean isGzipResponse(HttpURLConnection con) {
        String encodingHeader = con.getHeaderField("Content-Encoding");
        return encodingHeader != null && encodingHeader.toLowerCase().indexOf("gzip") != -1;
    }
}

