/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.support;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceUnit;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.InjectionMetadata;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.PriorityOrdered;
import org.springframework.jndi.JndiLocatorSupport;
import org.springframework.orm.jpa.EntityManagerFactoryInfo;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.orm.jpa.EntityManagerProxy;
import org.springframework.orm.jpa.ExtendedEntityManagerCreator;
import org.springframework.orm.jpa.SharedEntityManagerCreator;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceAnnotationBeanPostProcessor
extends JndiLocatorSupport
implements InstantiationAwareBeanPostProcessor,
DestructionAwareBeanPostProcessor,
MergedBeanDefinitionPostProcessor,
PriorityOrdered,
BeanFactoryAware,
Serializable {
    private transient Map<String, String> persistenceUnits;
    private transient Map<String, String> persistenceContexts;
    private transient Map<String, String> extendedPersistenceContexts;
    private transient String defaultPersistenceUnitName = "";
    private int order = 0x7FFFFFFB;
    private transient ListableBeanFactory beanFactory;
    private final transient Map<Class<?>, InjectionMetadata> injectionMetadataCache = new ConcurrentHashMap();
    private final Map<Object, EntityManager> extendedEntityManagersToClose = new ConcurrentHashMap<Object, EntityManager>();

    public PersistenceAnnotationBeanPostProcessor() {
        this.setResourceRef(true);
    }

    public void setPersistenceUnits(Map<String, String> persistenceUnits) {
        this.persistenceUnits = persistenceUnits;
    }

    public void setPersistenceContexts(Map<String, String> persistenceContexts) {
        this.persistenceContexts = persistenceContexts;
    }

    public void setExtendedPersistenceContexts(Map<String, String> extendedPersistenceContexts) {
        this.extendedPersistenceContexts = extendedPersistenceContexts;
    }

    public void setDefaultPersistenceUnitName(String unitName) {
        this.defaultPersistenceUnitName = unitName != null ? unitName : "";
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ListableBeanFactory) {
            this.beanFactory = (ListableBeanFactory)beanFactory;
        }
    }

    @Override
    public void postProcessMergedBeanDefinition(RootBeanDefinition beanDefinition, Class beanType, String beanName) {
        if (beanType != null) {
            InjectionMetadata metadata = this.findPersistenceMetadata(beanType);
            metadata.checkConfigMembers(beanDefinition);
        }
    }

    @Override
    public Object postProcessBeforeInstantiation(Class beanClass, String beanName) throws BeansException {
        return null;
    }

    @Override
    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findPersistenceMetadata(bean.getClass());
        try {
            metadata.injectFields(bean, beanName);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of persistence fields failed", ex);
        }
        return true;
    }

    @Override
    public PropertyValues postProcessPropertyValues(PropertyValues pvs, PropertyDescriptor[] pds, Object bean, String beanName) throws BeansException {
        InjectionMetadata metadata = this.findPersistenceMetadata(bean.getClass());
        try {
            metadata.injectMethods(bean, beanName, pvs);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Injection of persistence methods failed", ex);
        }
        return pvs;
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    @Override
    public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {
        EntityManager emToClose = this.extendedEntityManagersToClose.remove(bean);
        EntityManagerFactoryUtils.closeEntityManager(emToClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InjectionMetadata findPersistenceMetadata(final Class clazz) {
        InjectionMetadata metadata = this.injectionMetadataCache.get(clazz);
        if (metadata == null) {
            Map<Class<?>, InjectionMetadata> map = this.injectionMetadataCache;
            synchronized (map) {
                metadata = this.injectionMetadataCache.get(clazz);
                if (metadata == null) {
                    final InjectionMetadata newMetadata = new InjectionMetadata(clazz);
                    ReflectionUtils.doWithFields(clazz, new ReflectionUtils.FieldCallback(){

                        public void doWith(Field field) {
                            PersistenceContext pc = field.getAnnotation(PersistenceContext.class);
                            PersistenceUnit pu = field.getAnnotation(PersistenceUnit.class);
                            if (pc != null || pu != null) {
                                if (Modifier.isStatic(field.getModifiers())) {
                                    throw new IllegalStateException("Persistence annotations are not supported on static fields");
                                }
                                newMetadata.addInjectedField(new PersistenceElement(field, null));
                            }
                        }
                    });
                    ReflectionUtils.doWithMethods(clazz, new ReflectionUtils.MethodCallback(){

                        public void doWith(Method method) {
                            PersistenceContext pc = method.getAnnotation(PersistenceContext.class);
                            PersistenceUnit pu = method.getAnnotation(PersistenceUnit.class);
                            if (pc != null || pu != null && method.equals(ClassUtils.getMostSpecificMethod(method, clazz))) {
                                if (Modifier.isStatic(method.getModifiers())) {
                                    throw new IllegalStateException("Persistence annotations are not supported on static methods");
                                }
                                if (method.getParameterTypes().length != 1) {
                                    throw new IllegalStateException("Persistence annotation requires a single-arg method: " + method);
                                }
                                PropertyDescriptor pd = BeanUtils.findPropertyForMethod(method);
                                newMetadata.addInjectedMethod(new PersistenceElement(method, pd));
                            }
                        }
                    });
                    metadata = newMetadata;
                    this.injectionMetadataCache.put(clazz, metadata);
                }
            }
        }
        return metadata;
    }

    protected EntityManagerFactory getPersistenceUnit(String unitName) {
        if (this.persistenceUnits != null) {
            String jndiName;
            String unitNameForLookup;
            String string = unitNameForLookup = unitName != null ? unitName : "";
            if ("".equals(unitNameForLookup)) {
                unitNameForLookup = this.defaultPersistenceUnitName;
            }
            if ((jndiName = this.persistenceUnits.get(unitNameForLookup)) == null && "".equals(unitNameForLookup) && this.persistenceUnits.size() == 1) {
                jndiName = this.persistenceUnits.values().iterator().next();
            }
            if (jndiName != null) {
                try {
                    return (EntityManagerFactory)this.lookup(jndiName, EntityManagerFactory.class);
                }
                catch (NamingException ex) {
                    throw new IllegalStateException("Could not obtain EntityManagerFactory [" + jndiName + "] from JNDI", ex);
                }
            }
        }
        return null;
    }

    protected EntityManager getPersistenceContext(String unitName, boolean extended) {
        Map<String, String> contexts;
        Map<String, String> map = contexts = extended ? this.extendedPersistenceContexts : this.persistenceContexts;
        if (contexts != null) {
            String jndiName;
            String unitNameForLookup;
            String string = unitNameForLookup = unitName != null ? unitName : "";
            if ("".equals(unitNameForLookup)) {
                unitNameForLookup = this.defaultPersistenceUnitName;
            }
            if ((jndiName = contexts.get(unitNameForLookup)) == null && "".equals(unitNameForLookup) && contexts.size() == 1) {
                jndiName = contexts.values().iterator().next();
            }
            if (jndiName != null) {
                try {
                    return (EntityManager)this.lookup(jndiName, EntityManager.class);
                }
                catch (NamingException ex) {
                    throw new IllegalStateException("Could not obtain EntityManager [" + jndiName + "] from JNDI", ex);
                }
            }
        }
        return null;
    }

    protected EntityManagerFactory findEntityManagerFactory(String unitName, String requestingBeanName) throws NoSuchBeanDefinitionException {
        String unitNameForLookup;
        if (this.beanFactory == null) {
            throw new IllegalStateException("ListableBeanFactory required for EntityManagerFactory bean lookup");
        }
        String string = unitNameForLookup = unitName != null ? unitName : "";
        if ("".equals(unitNameForLookup)) {
            unitNameForLookup = this.defaultPersistenceUnitName;
        }
        if (!"".equals(unitNameForLookup)) {
            return this.findNamedEntityManagerFactory(unitNameForLookup, requestingBeanName);
        }
        return this.findDefaultEntityManagerFactory(requestingBeanName);
    }

    protected EntityManagerFactory findNamedEntityManagerFactory(String unitName, String requestingBeanName) throws NoSuchBeanDefinitionException {
        EntityManagerFactory emf = EntityManagerFactoryUtils.findEntityManagerFactory(this.beanFactory, unitName);
        if (this.beanFactory instanceof ConfigurableBeanFactory) {
            ((ConfigurableBeanFactory)((Object)this.beanFactory)).registerDependentBean(unitName, requestingBeanName);
        }
        return emf;
    }

    protected EntityManagerFactory findDefaultEntityManagerFactory(String requestingBeanName) throws NoSuchBeanDefinitionException {
        String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(this.beanFactory, EntityManagerFactory.class);
        if (beanNames.length == 1) {
            String unitName = beanNames[0];
            EntityManagerFactory emf = (EntityManagerFactory)this.beanFactory.getBean(unitName);
            if (this.beanFactory instanceof ConfigurableBeanFactory) {
                ((ConfigurableBeanFactory)((Object)this.beanFactory)).registerDependentBean(unitName, requestingBeanName);
            }
            return emf;
        }
        throw new NoSuchBeanDefinitionException(EntityManagerFactory.class, "expected single bean but found " + beanNames.length);
    }

    private class PersistenceElement
    extends InjectionMetadata.InjectedElement {
        private final String unitName;
        private PersistenceContextType type;
        private Properties properties;

        public PersistenceElement(Member member, PropertyDescriptor pd) {
            super(member, pd);
            AnnotatedElement ae = (AnnotatedElement)((Object)member);
            PersistenceContext pc = ae.getAnnotation(PersistenceContext.class);
            PersistenceUnit pu = ae.getAnnotation(PersistenceUnit.class);
            Class<EntityManager> resourceType = EntityManager.class;
            if (pc != null) {
                if (pu != null) {
                    throw new IllegalStateException("Member may only be annotated with either @PersistenceContext or @PersistenceUnit, not both: " + member);
                }
                Properties properties = null;
                Object[] pps = pc.properties();
                if (!ObjectUtils.isEmpty(pps)) {
                    properties = new Properties();
                    for (int i = 0; i < pps.length; ++i) {
                        Object pp = pps[i];
                        properties.setProperty(pp.name(), pp.value());
                    }
                }
                this.unitName = pc.unitName();
                this.type = pc.type();
                this.properties = properties;
            } else {
                resourceType = EntityManagerFactory.class;
                this.unitName = pu.unitName();
            }
            this.checkResourceType(resourceType);
        }

        protected Object getResourceToInject(Object target, String requestingBeanName) {
            if (this.type != null) {
                return this.type == PersistenceContextType.EXTENDED ? this.resolveExtendedEntityManager(target, requestingBeanName) : this.resolveEntityManager(requestingBeanName);
            }
            return this.resolveEntityManagerFactory(requestingBeanName);
        }

        private EntityManagerFactory resolveEntityManagerFactory(String requestingBeanName) {
            EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
            if (emf == null) {
                emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName, requestingBeanName);
            }
            return emf;
        }

        private EntityManager resolveEntityManager(String requestingBeanName) {
            EntityManager em = PersistenceAnnotationBeanPostProcessor.this.getPersistenceContext(this.unitName, false);
            if (em == null) {
                EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
                if (emf == null) {
                    emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName, requestingBeanName);
                }
                em = emf instanceof EntityManagerFactoryInfo && ((EntityManagerFactoryInfo)emf).getEntityManagerInterface() != null ? SharedEntityManagerCreator.createSharedEntityManager(emf, this.properties) : SharedEntityManagerCreator.createSharedEntityManager(emf, this.properties, this.getResourceType());
            }
            return em;
        }

        private EntityManager resolveExtendedEntityManager(Object target, String requestingBeanName) {
            EntityManager em = PersistenceAnnotationBeanPostProcessor.this.getPersistenceContext(this.unitName, true);
            if (em == null) {
                EntityManagerFactory emf = PersistenceAnnotationBeanPostProcessor.this.getPersistenceUnit(this.unitName);
                if (emf == null) {
                    emf = PersistenceAnnotationBeanPostProcessor.this.findEntityManagerFactory(this.unitName, requestingBeanName);
                }
                em = ExtendedEntityManagerCreator.createContainerManagedEntityManager(emf, this.properties);
            }
            if (em instanceof EntityManagerProxy && PersistenceAnnotationBeanPostProcessor.this.beanFactory != null && !PersistenceAnnotationBeanPostProcessor.this.beanFactory.isPrototype(requestingBeanName)) {
                PersistenceAnnotationBeanPostProcessor.this.extendedEntityManagersToClose.put(target, ((EntityManagerProxy)em).getTargetEntityManager());
            }
            return em;
        }
    }
}

