/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.util.Map;

import jp.terasoluna.fw.file.dao.FileException;

/**
 * CSVt@Cp̃t@CANZX(f[^擾)NXB
 * <p>
 * CSVt@Cf[^ǂݍ݁A1s̃f[^t@CsIuWFNgɊi[B
 * </p>
 * <b>pt@CsIuWFNg̃Ame[V</b><br>
 * @D@{@link FileFormat}̐ݒ荀<br>
 * <div align="center">
 * <table width="90%" border="1" bgcolor="#FFFFFF">
 * <tr>
 * <td><b>_ږ</b></td>
 * <td><b>ږ</b></td>
 * <td><b>ftHgl</b></td>
 * <td><b>K{</b></td>
 * </tr>
 * <tr>
 * <td> <code>s؂蕶</code></td>
 * <td> <code>lineFeedChar</code></td>
 * <td> <code>VXe̍s؂蕶</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>͂ݕ</code></td>
 * <td> <code>encloseChar</code></td>
 * <td> <code>Ȃ('\u0000')</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>t@CGR[fBO</code></td>
 * <td> <code>fileEncodeing</code></td>
 * <td> <code>VXẽt@CGR[fBO</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>wb_s</code></td>
 * <td> <code>headerLineCount</code></td>
 * <td> <code>0</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>gCs</code></td>
 * <td> <code>trailerLineCount</code></td>
 * <td> <code>0</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * </table>
 * </div> <br>
 * AD@{@link jp.terasoluna.fw.file.annotation.InputFileColumn}A@{@link jp.terasoluna.fw.file.annotation.OutputFileColumn}̐ݒ荀<br>
 * <div align="center">
 * <table width="90%" border="1" bgcolor="#FFFFFF">
 * <tr>
 * <td><b>_ږ</b></td>
 * <td><b>ږ</b></td>
 * <td><b>ftHgl</b></td>
 * <td><b>K{</b></td>
 * </tr>
 * <tr>
 * <td> <code>JCfbNX</code></td>
 * <td> <code>columnIndex</code></td>
 * <td>-</td>
 * <td> <code>K{</code></td>
 * </tr>
 * <tr>
 * <td> <code>tH[}bg</code></td>
 * <td> <code>columnFormat</code></td>
 * <td> <code>""</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>oCg</code></td>
 * <td> <code>bytes</code></td>
 * <td>-</td>
 * <td> <code>K{</code></td>
 * </tr>
 * <tr>
 * <td> <code>pfBO</code></td>
 * <td> <code>paddingType</code></td>
 * <td> <code>pfBOȂ</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>pfBO</code></td>
 * <td> <code>paddingChar</code></td>
 * <td> <code>' '</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>g</code></td>
 * <td> <code>trimType</code></td>
 * <td> <code>gȂ</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>g</code></td>
 * <td> <code>trimChar</code></td>
 * <td> <code>' '</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * <tr>
 * <td> <code>ϊ</code></td>
 * <td> <code>stringConverter</code></td>
 * <td> <code>NullStringConverter.class</code></td>
 * <td> <code>IvV</code></td>
 * </tr>
 * </table>
 * </div> <br>
 * <b>ӎ</b><br>
 * <ul>
 * @
 * <li>؂蕶<code>','</cod>ȊOɐݒ肷邱Ƃ͏oȂB(G[)</li>
 * </ul>
 * @param <T> t@CsIuWFNgB
 */
public class CSVFileLineIterator<T> extends VariableFileLineIterator<T> {

    /**
     * RXgN^B
     * @param fileName t@C
     * @param clazz t@CsʃNX
     * @param columnParserMap JtH[}bgi[}bv
     */
    public CSVFileLineIterator(String fileName, Class<T> clazz,
            Map<String, ColumnParser> columnParserMap) {

        super(fileName, clazz, columnParserMap);

        // ؂蕶lȊȌꍇAOX[B
        if (getDelimiter() != ',') {
            throw new FileException("Delimiter can not change.",
                    new IllegalStateException(), fileName);
        }

        // sB
        super.init();
    }
}
