/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import jp.terasoluna.fw.file.annotation.PaddingType;
import jp.terasoluna.fw.file.annotation.TrimType;
import jp.terasoluna.fw.file.dao.FileException;

/**
 * FileDAOp̃[eBeBB
 * <p>
 * pfBOAg񋟂B
 * </p>
 */
public class FileDAOUtility {

    /**
     * t@CGR[fBÕLbVB
     */
    private static final Map<String, Map<Character, Boolean>> encodingCache = new ConcurrentHashMap<String, Map<Character, Boolean>>();

    /**
     * pfBOB<br>
     * <br>
     * J̕Ame[VŎw肳ꂽŃpfBOB<br>
     * ɒǉ̂́ApfBOupaddingCharvŎw肵B<br>
     * pfBO͔p1ł̂ŁASp͂ꂽꍇ͓̓G[ƂȂB
     * @param columnString pfBOÔPJ̕
     * @param fileEncoding t@CGR[fBO
     * @param columnBytes pfBO1J̃oCg
     * @param paddingChar pfBO
     * @param paddingType pfBO^Cv
     * @return pfBOς̂PJ̕
     */
    public static String padding(String columnString, String fileEncoding,
            int columnBytes, char paddingChar, PaddingType paddingType) {

        // NONÊƂ͂̂܂ܕԋp
        if (PaddingType.NONE.equals(paddingType)) {
            return columnString;
        }

        // p̔
        if (!isHalfWidthChar(fileEncoding, paddingChar)) {
            throw new FileException("Padding char is not half-width character.");
        }

        try {
            // pfBÕoCgΏە񂪒ꍇ̓pfBOȂB
            int paddingSize = columnBytes
                    - columnString.getBytes(fileEncoding).length;

            if (paddingSize <= 0) {
                return columnString;
            }

            StringBuilder columnBuilder = new StringBuilder(columnBytes);

            char[] fillChars = new char[paddingSize];
            Arrays.fill(fillChars, paddingChar);

            if (PaddingType.LEFT.equals(paddingType)) {
                columnBuilder.append(fillChars).append(columnString);
                return columnBuilder.toString();

            } else if (PaddingType.RIGHT.equals(paddingType)) {
                columnBuilder.append(columnString).append(fillChars);
                return columnBuilder.toString();

            } else {
                return columnString;
            }
        } catch (UnsupportedEncodingException e) {
            throw new FileException("Specified Encoding : " + fileEncoding
                    + " is not supported", e);
        }
    }

    /**
     * gB<br>
     * <br>
     * J̕Ame[VŎw肳ꂽŃgB<br>
     * 񂩂菜̂́AgutrimCharvŎw肵B<br>
     * g͔p1ł̂ŁASp͂ꂽꍇ͓̓G[ƂȂB
     * @param columnString gÔPJ̕
     * @param fileEncoding t@CGR[fBO
     * @param trimChar g(p)
     * @param trimType g^Cv
     * @return ĝPJ̕
     */
    public static String trim(String columnString, String fileEncoding,
            char trimChar, TrimType trimType) {

        // NONÊƂ͂̂܂ܕԋp
        if (TrimType.NONE.equals(trimType)) {
            return columnString;
        }

        // p̔
        if (!isHalfWidthChar(fileEncoding, trimChar)) {
            throw new FileException("Trim char is not half-width character.");
        }

        int start = 0;
        int length = columnString.length();

        if (TrimType.LEFT.equals(trimType) || TrimType.BOTH.equals(trimType)) {
            while ((start < length) && columnString.charAt(start) == trimChar) {
                start++;
            }
        }
        if (TrimType.RIGHT.equals(trimType) || TrimType.BOTH.equals(trimType)) {
            while ((start < length)
                    && columnString.charAt(length - 1) == trimChar) {
                length--;
            }
        }
        return columnString.substring(start, length);
    }

    /**
     * p`FbNsB
     * @param fileEncoding t@CGR[fBO
     * @param checkChar `FbNs
     * @return p̏ꍇtrueԋp
     * @throws FileException ݂ȂGR[fBȌꍇ
     */
    private static boolean isHalfWidthChar(String fileEncoding, char checkChar)
                                                                               throws FileException {

        Map<Character, Boolean> cache = encodingCache.get(fileEncoding);
        if (cache == null) {
            cache = new ConcurrentHashMap<Character, Boolean>();
            encodingCache.put(fileEncoding, cache);
        }

        Boolean result = cache.get(checkChar);
        if (result == null) {
            try {
                result = (1 == Character.toString(checkChar).getBytes(
                        fileEncoding).length);
                cache.put(checkChar, result);
            } catch (UnsupportedEncodingException e) {
                throw new FileException("Specified Encoding : " + fileEncoding
                        + " is not supported", e);
            }
        }
        return result.booleanValue();
    }
}
