/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import jp.terasoluna.fw.beans.jxpath.BeanPointerFactoryEx;
import jp.terasoluna.fw.beans.jxpath.DynamicPointerFactoryEx;

import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.JXPathContextReferenceImpl;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * JXPathpIndexBeanWrapper̎B
 * 
 * <p>JavaBeanAMapADynaBeanvpeBw肷邱ƂɂA
 * l擾邱ƂłB
 * zEList^̏ꍇAY鑮lSĎ擾B
 * <h5>擾ł鑮̌^</h5>
 * <ul>
 *   <li>v~eBu^</li>
 *   <li>v~eBu^̔z</li>
 *   <li>JavaBean</li>
 *   <li>JavaBean̔zEList^</li>
 *   <li>Map^</li>
 * </ul>
 * </p>
 * 
 * <p>
 * MapIuWFNgA܂Map^gpꍇA
 * ȉ̕MapL[ɎgpłȂB
 * <ul>
 *   <li>/ cXbV</li>
 *   <li>[ cpiJj</li>
 *   <li>] cpij</li>
 *   <li>. chbg</li>
 *   <li>' cVONH[g</li>
 *   <li>" c_uNH[g</li>
 *   <li>( ciJj</li>
 *   <li>) cij</li>
 * </ul>
 * </p>
 * 
 * <hr>
 *
 * <h4>ȒPȎgp</h4>
 *
 * <p>ȉ̂悤EmployeeIuWFNgfirstNameɃANZXB
 * <pre>
 * public class Employee {
 *     private String firstName;
 *
 *     public void setFirstName(String firstName) {
 *         this.firstName = firstName;
 *     }
 *     public String getFirstName() {
 *         return firstName;
 *     }
 * }
 * </pre>
 * </p>
 *
 * <p><u>PDRXgN^ŃANZXΏۂJavaBeanbvB</u>
 * <pre>
 * // ANZXΏۂƂȂEmployeeIuWFNg
 * Employee emp = new Employee();
 * emp.setFirstName("߂");
 * 
 * IndexedBeanWrapper bw = new JXPathIndexedBeanWrapperImpl(emp);
 * </pre>
 * </p>
 *
 * <p><u>QDfirstNameɃANZXB</u>
 * Stringɂ͑w肷B
 * <pre>
 * Map&lt;String, Object&gt; map = bw.getIndexedPropertyValues("<strong>firstName</strong>");
 * </pre>
 * 
 * L[vpeBAllMapCX^XԂB
 * ȉ̃R[hł͑SĂ̗vfR\[ɏo͂ĂB
 * <pre>
 * System.out.println("Map̃L[FMap̒l");
 * System.out.println("========================");
 * Set&lt;String&gt; keyset = map.keySet();
 * for (String key : keyset) {
 *     System.out.print(key + ":");
 *     System.out.println(map.get(key).toString());
 * }
 * </pre>
 * ʂ͈ȉ̂悤ɏo͂B
 * <pre>
 * Map̃L[FMap̒l
 * ========================
 * firstName:߂
 * </pre>
 * </p>
 * 
 * <hr>
 *
 * <h4>z񑮐ւ̃ANZX</h4>
 *
 * <p>ȉ̂悤AddressIuWFNg̔z^numbersɃANZXB
 * <pre>
 * public class Address {
 *     private int[] numbers;
 *
 *     public void setNumbers(int[] numbers) {
 *         this.numbers = numbers;
 *     }
 *     public int[] getNumbers() {
 *         return numbers;
 *     }
 * }
 * </pre>
 * </p>
 *
 * <p><u>PDRXgN^ŃANZXΏۂJavaBeanbvB</u>
 * <pre>
 * // EmployeȇƂȂAddressIuWFNg
 * Address address = new Address();
 * address.setNumbers(new int[]{1, 2, 3});
 * 
 * IndexedBeanWrapper bw = new JXPathIndexedBeanWrapperImpl(address);
 * </pre>
 * </p>
 *
 * <p><u>QDnumbersɃANZXB</u>
 * <em>'numbers[]'̂悤ɔzLtKv͂ȂA
 * w肷΂悢Ƃɒӂ邱ƁB</em>
 * <pre>
 * Map&lt;String, Object&gt; map = bw.getIndexedPropertyValues("<strong>numbers</strong>");
 * </pre>
 * </p>
 *
 * L[vpeBAllMapCX^XԂB
 * ȉ̃R[hł͑SĂ̗vfR\[ɏo͂ĂB
 * <pre>
 * System.out.println("Map̃L[FMap̒l");
 * System.out.println("========================");
 * Set&lt;String&gt; keyset = map.keySet();
 * for (String key : keyset) {
 *     System.out.print(key + ":");
 *     System.out.println(map.get(key).toString());
 * }
 * </pre>
 * ʂ͈ȉ̂悤ɏo͂B
 * <pre>
 * Map̃L[FMap̒l
 * ========================
 * numbers[0]:1
 * numbers[1]:2
 * numbers[2]:3
 * </pre>
 * List^̃IuWFNgɑ΂ĂAl̕@Œl擾łB
 * </p>
 * 
 * <hr>
 *
 * <h4>lXgւ̃ANZX</h4>
 *
 * <p>L̂悤EmployeeIuWFNgA
 * lXgꂽAddressNXstreetNumberɃANZXB
 * <pre>
 * public class Employee {
 *     private Address homeAddress;
 *
 *     public void setHomeAddress(Address homeAddress) {
 *         this.homeAddress = homeAddress;
 *     }
 *     public Address getHomeAddress() {
 *         return homeAddress;
 *     }
 * }
 * public class Address {
 *     private String streetNumber;
 *
 *     public void setStreetNumber(String streetNumber) {
 *         this.streetNumber = streetNumber;
 *     }
 *     public String getStreetNumber() {
 *         return streetNumber;
 *     }
 * }
 * </pre>
 * </p>
 * 
 * <p><u>PDRXgN^ŃANZXΏۂJavaBeanbvB</u>
 * <pre>
 * // EmployeȇƂȂAddressIuWFNg
 * Address address = new Address();
 * address.setStreetNumber("Z");
 * 
 * // Employee
 * Employee emp = new Employee();
 * emp.setHomeAddress(address);
 * 
 * IndexedBeanWrapper bw = new JXPathIndexedBeanWrapperImpl(emp);
 * </pre>
 * </p>
 *
 * <p><u>QDEmployeeIuWFNghomeAddressɃlXgꂽA
 * streetNumberɃANZXB</u>
 * lXgw肷ꍇAȉ̃R[ĥ悤'.'ihbgj
 * AB
 * <pre>
 * Map&lt;String, Object&gt; map = bw.getIndexedPropertyValues("<strong>homeAddress.streetNumber</strong>");
 * </pre>
 * </p>
 * 
 * L[vpeBAllMapCX^XԂB
 * ȉ̃R[hł͑SĂ̗vfR\[ɏo͂ĂB
 * <pre>
 * System.out.println("Map̃L[FMap̒l");
 * System.out.println("========================");
 * Set&lt;String&gt; keyset = map.keySet();
 * for (String key : keyset) {
 *     System.out.print(key + ":");
 *     System.out.println(map.get(key).toString());
 * }
 * </pre>
 * ʂ͈ȉ̂悤ɏo͂B
 * <pre>
 * Map̃L[FMap̒l
 * ========================
 * homeAddress.streetNumber:Z
 * </pre>
 * lXgzEList^łĂAl擾邱ƂłB
 * </p>
 * 
 * <hr>
 *
 * <h4>Map^ւ̃ANZX</h4>
 *
 * <p>L̂悤EmployeeIuWFNgMapaddressMapɃANZXB
 * <pre>
 * public class Employee {
 *     private Map addressMap;
 *
 *     public void setAddressMap(Map addressMap) {
 *         this.addressMap = addressMap;
 *     }
 *     public Map getAddressMap() {
 *         return addressMap;
 *     }
 * }
 * </pre>
 * </p>
 * 
 * <p><u>PDRXgN^ŃANZXΏۂJavaBeanbvB</u>
 * <pre>
 * // EmployeȇƂȂMap
 * Map addressMap = new HashMap();
 * addressMap.put("home", "address1");
 * 
 * // Employee
 * Employee emp = new Employee();
 * emp.setAddressMap(addressMap);
 * 
 * IndexedBeanWrapper bw = new JXPathIndexedBeanWrapperImpl(emp);
 * </pre>
 * </p>
 *
 * <p><u>QDEmployeeaddressMapɃZbghomeL[ɃANZXB</u>
 * Map^̃L[w肷ꍇAȉ̃R[ĥ悤ɂŃL[AB
 * <pre>
 * Map&lt;String, Object&gt; map = bw.getIndexedPropertyValues("<strong>addressMap(home)</strong>");
 * </pre>
 * </p>
 * 
 * L[vpeBAllMapCX^XԂB
 * ȉ̃R[hł͑SĂ̗vfR\[ɏo͂ĂB
 * <pre>
 * System.out.println("Map̃L[FMap̒l");
 * System.out.println("========================");
 * Set&lt;String&gt; keyset = map.keySet();
 * for (String key : keyset) {
 *     System.out.print(key + ":");
 *     System.out.println(map.get(key).toString());
 * }
 * </pre>
 * ʂ͈ȉ̂悤ɏo͂B
 * <pre>
 * Map̃L[FMap̒l
 * ========================
 * addressMap(home):address1
 * </pre>
 * Map^̃L[()iʁjň͂邱Ƃɒӂ邱ƁB
 * </p>
 *
 * <hr>
 *
 * <h4>MapIuWFNgւ̃ANZX</h4>
 *
 * <p>{NXJavaBeanł͂ȂAMapIuWFNgւ̃ANZX\łB
 * 
 * <p><u>PDRXgN^ŃANZXΏۂMapbvB</u>
 * <pre>
 * // EmployeȇƂȂMap
 * Map addressMap = new HashMap();
 * addressMap.put("home", "address1");
 * 
 * IndexedBeanWrapper bw = new JXPathIndexedBeanWrapperImpl(addressMap);
 * </pre>
 * </p>
 *
 * <p><u>QDaddressMapɃZbghomeL[ɃANZXB</u>
 * <pre>
 * Map&lt;String, Object&gt; map = bw.getIndexedPropertyValues("<strong>home</strong>");
 * </pre>
 * </p>
 * 
 * L[vpeBAllMapCX^XԂB
 * ȉ̃R[hł͑SĂ̗vfR\[ɏo͂ĂB
 * <pre>
 * System.out.println("Map̃L[FMap̒l");
 * System.out.println("========================");
 * Set&lt;String&gt; keyset = map.keySet();
 * for (String key : keyset) {
 *     System.out.print(key + ":");
 *     System.out.println(map.get(key).toString());
 * }
 * </pre>
 * ʂ͈ȉ̂悤ɏo͂B
 * <pre>
 * Map̃L[FMap̒l
 * ========================
 * home:address1
 * </pre>
 * MapIuWFNgɑ΂ĂAzEList^A
 * lXg̎擾\łB
 * </p>
 * 
 * <hr>
 *
 * <h4>DynaBeanւ̃ANZX</h4>
 *
 * <p>{NXJavaBeanł͂ȂADynaBeanւ̃ANZX\łB
 * 
 * <p><u>PDRXgN^ŃANZXΏۂDynaBeanbvB</u>
 * <pre>
 * // DynaBeanɃbvJavaBean
 * Address address = new Address();
 * address.setStreetNumber("Z");
 * 
 * // DynaBean
 * DynaBean dynaBean = new WrapDynaBean(address);
 * 
 * IndexedBeanWrapper bw = new JXPathIndexedBeanWrapperImpl(dynaBean);
 *     
 * --------------------------------------------------------
 * L̃R[hŎgpĂAddressIuWFNg͈ȉ̂悤ȃNXłB
 * 
 * public class Address {
 *     private String streetNumber;
 *
 *     public void setStreetNumber(String streetNumber) {
 *         this.streetNumber = streetNumber;
 *     }
 *     public String getStreetNumber() {
 *         return streetNumber;
 *     }
 * }
 * </pre>
 * 
 * </p>
 *
 * <p><u>QDDynaBeanstreetNumberɃANZXB</u>
 * <pre>
 * Map&lt;String, Object&gt; map = bw.getIndexedPropertyValues("<strong>streetNumber</strong>");
 * </pre>
 * </p>
 * 
 * L[vpeBAllMapCX^XԂB
 * ȉ̃R[hł͑SĂ̗vfR\[ɏo͂ĂB
 * <pre>
 * System.out.println("Map̃L[FMap̒l");
 * System.out.println("========================");
 * Set&lt;String&gt; keyset = map.keySet();
 * for (String key : keyset) {
 *     System.out.print(key + ":");
 *     System.out.println(map.get(key).toString());
 * }
 * </pre>
 * ʂ͈ȉ̂悤ɏo͂B
 * <pre>
 * Map̃L[FMap̒l
 * ========================
 * streetNumber:Z
 * </pre>
 * </p>
 * 
 */
public class JXPathIndexedBeanWrapperImpl implements IndexedBeanWrapper {
    /**
     * ONXB
     */
    private static Log log 
        = LogFactory.getLog(JXPathIndexedBeanWrapperImpl.class);
    
    /**
     * JXPathReLXgB
     */
    protected JXPathContext context = null;
    
    /**
     * B
     * 
     * <p>gNodePointert@NgǉB
     * NodePointert@Ngstatic\bhŁAxĂяoB
     * sNodePointert@NgǉsȂƁA
     * }`XbhɂNullPointerException\B</p>
     */
    static {
    	JXPathContextReferenceImpl.addNodePointerFactory(
                new BeanPointerFactoryEx());
        JXPathContextReferenceImpl.addNodePointerFactory(
                new DynamicPointerFactoryEx());
    }
    
    /**
     * RXgN^B
     * @param target Ώۂ̃IuWFNg
     */
    public JXPathIndexedBeanWrapperImpl(Object target) {
        // ^[QbgƂȂJavaBeanNull̏ꍇ͗O
        if (target == null) {
            log.error("TargetBean is null!");
            throw new IllegalArgumentException("TargetBean is null!");
        }
        context = JXPathContext.newContext(target);
    }
    
    /**
     * w肵vpeBɈv鑮lԂB
     *
     * @param propertyName vpeB
     * @return vpeBɈv鑮li[MapiʒuAlj
     */
    public Map<String, Object> getIndexedPropertyValues(String propertyName) {
        
        // vpeBNullE󕶎
        if (StringUtils.isEmpty(propertyName)) {
            String message = "PropertyName is empty!";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        
        // vpeBɕsȕ
        if (StringUtils.indexOfAny(propertyName,
                new char[]{'/', '"', '\''}) != -1) { 
            String message = "Invalid character has found within property name."
                + " '" + propertyName + "' " + "Cannot use [ / \" ' ]";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        
        // z[]ȊO[]gĂ
        String stringIndex = extractIndex(propertyName);
        if (stringIndex.length() > 0) {
            try {
                Integer.parseInt(stringIndex);
            } catch (NumberFormatException e) {
                String message = "Invalid character has found within property name."
                    + " '" + propertyName + "' " + "Cannot use [ [] ]";
                log.error(message);
                throw new IllegalArgumentException(message);
            }
        }
        
        Map<String, Object> result
            = new LinkedHashMap<String, Object>();
        String requestXpath = toXPath(propertyName);
        
        // JXPathvpeB擾
        Iterator ite = null;
        try {
            ite = context.iteratePointers(requestXpath);
        } catch (JXPathException e) {
            // vpeBs
            String message = 
                "Invalid property name. "
                + "PropertyName: '" + propertyName + "'"
                + "XPath: '" + requestXpath + "'";
            log.error(message, e);
            throw new IllegalArgumentException(message, e);
        }
        
        // XPath  Java property
        while (ite.hasNext()) {
            Pointer p = (Pointer) ite.next();
            result.put(this.toPropertyName(p.asPath()), p.getValue());
        }
        return result;
    }
    
    /**
     * vpeB`̕XPath`̕ɕϊB
     * @param propertyName vpeB`
     * @return XPath`
     */
    protected String toXPath(String propertyName) {
        StringBuilder builder = new StringBuilder("/");
        String[] properties = StringUtils.split(propertyName, '.');
        
        if (properties == null || properties.length == 0) {
            String message = "Property name is null or blank.";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        
        for (String property : properties) {
            // lXg
            if (builder.length() > 1) {
                builder.append('/');
            }
            
            // Map
            if (isMapProperty(property)) {
                builder.append(escapeMapProperty(property));
                
            // JavaBean ܂ Primitive
            } else {
                builder.append(extractAttributeName(property));
            }
           
            // zCfbNX
            builder.append(extractIncrementIndex(property));
        }
        return builder.toString();
    }
    
    /**
     * CNgꂽYoB
     * @param property JavavpeBB
     * @return String XPath`̓YB 
     */
    protected String extractIncrementIndex(String property) {
        return extractIncrementIndex(property, 1);
    }

    /**
     * CNgꂽYoB
     * @param property vpeBB
     * @param increment CNglB
     * @return String CNgꂽYB
     */
    protected String extractIncrementIndex(String property, int increment) {
        String stringIndex = extractIndex(property);
        if ("".equals(stringIndex)) {
            return "";
        }
        
        // Y擾łꍇACNg
        try {
            int index = Integer.parseInt(stringIndex);
            return new StringBuilder().append('[')
                .append(index + increment).append(']').toString();
        } catch (NumberFormatException e) {
            // z[]ł͂Ȃ
            return "";
        }
    }

    /**
     * zCfbNX擾B
     * @param property vpeBB
     * @return zCfbNXB
     */
    protected String extractIndex(String property) {
        int start = property.lastIndexOf('[');
        int end = property.lastIndexOf(']');
        
        // []Ȃ̂Ŕzł͂Ȃ
        if (start == -1 && end == -1) {
            return "";
        }
        
        // ']aaa[' ̂悤[]̈ʒusA܂[]̂ǂ炩Ȃ
        if (start == -1 || end == -1 || start > end) {
            String message = "Cannot get Index. "
                + "Invalid property name. '" + property + "'";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        return property.substring(start + 1, end);
    }
    
    /**
     * MapvpeBXPath`ɃGXP[vB
     * @param property JavavpeBB
     * @return String XPathB 
     */
    protected String escapeMapProperty(String property) {
        // aaa(bbb)  aaa/bbb
        String mapPropertyName = extractMapPropertyName(property);
        String mapKey = extractMapPropertyKey(property);
        return mapPropertyName + "/" + mapKey;
    }

    /**
     * Map^̃vpeBoB
     * @param property JavavpeBB
     * @return String XPathB 
     */
    protected String extractMapPropertyName(String property) {
        int pos = property.indexOf('(');
        
        // '('Ȃꍇ͗O
        if (pos == -1) {
            String message = "Cannot get Map attribute. "
                + "Invalid property name. '" + property + "'";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        return property.substring(0, pos);
    }

    /**
     * Map^̃L[oB
     * @param property JavavpeBB
     * @return String XPathB 
     */
    protected String extractMapPropertyKey(String property) {
        // aaa(bbb)  bbb
        int start = property.indexOf('(');
        int end = property.indexOf(')');
        
        // '()'ȂA܂()̈ʒusȏꍇ͗O
        if (start == -1 || end == -1 || start > end) {
            String message = "Cannot get Map key. "
                + "Invalid property name. '" + property + "'";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        return property.substring(start + 1, end);
    }

    /**
     * Map^ǂfB
     * @param property JavavpeBB
     * @return boolean Map^ȂtrueAȊOfalseԂB 
     */
    protected boolean isMapProperty(String property) {
        // '()'Map^
        if (property.indexOf('(') != -1 && property.indexOf(')') != -1) {
            return true;
        }
        return false;
    }
    
    /**
     * XPath`̕vpeB`̕ɕϊB
     * @param xpath XPath`
     * @return vpeB`
     */
    protected String toPropertyName(String xpath) {
        StringBuilder builder = new StringBuilder("");
        String[] nodes = StringUtils.split(xpath, '/');
        
        if (nodes == null || nodes.length == 0) {
            String message = "XPath is null or blank.";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        
        for (int i = 0; i < nodes.length; i++) {
            String node = nodes[i];
            
            // MapIuWFNg
            if (i == 0 && isMapObject(node)) {
                builder.append(extractMapKey(node));
                builder.append(extractDecrementIndex(node));
                continue;
            }
            
            // lXg
            if (builder.length() > 0) {
                builder.append('.');
            }
            
            // Map
            if (isMapAttribute(node)) {
                builder.append(extractMapAttributeName(node));
                builder.append('(');
                builder.append(extractMapKey(node));
                builder.append(')');
                
            // JavaBean ܂ primitive
            } else {
                builder.append(extractAttributeName(node));
            }
            
            // zCfbNX
            builder.append(extractDecrementIndex(node));
        }
        return builder.toString();
    }

    /**
     * oB
     * z̏ꍇAY̓JbgB
     * @param node XPath̃m[hB
     * @return B
     */
    protected String extractAttributeName(String node) {
        int pos = node.lastIndexOf('[');
        if (pos == -1) {
            return node;
        }
        // z̓Y̓Jbg
        return node.substring(0, pos);
    }

    /**
     * Map̑oB
     * @param node XPath̃m[hB
     * @return B
     */
    protected String extractMapAttributeName(String node) {
        // ŏ'['܂ł̕Map̑Ƃ
        int pos = node.indexOf('[');
        
        // '['Ȃꍇ͗O
        if (pos == -1) {
            String message = "Cannot get Map attribute. "
                + "Invalid property name. '" + node + "'";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        return node.substring(0, pos);
    }

    /**
     * MapL[oB
     * @param node XPath̃m[hB
     * @return B
     */
    protected String extractMapKey(String node) {
        // aaa[@name='bbb']  bbb 
        int start = node.indexOf('[');
        int end = node.indexOf(']');
        
        // '[]'ȂA܂[]̈ʒusȏꍇ͗O
        if (start == -1 || end == -1 || start > end) {
            String message = "Cannot get Map key. "
                + "Invalid property name. '" + node + "'";
            log.error(message);
            throw new IllegalArgumentException(message);
        }
        return node.substring(start + "[@name='".length(), end - "'".length());
    }

    /**
     * fNgYoB
     * @param node XPath̃m[hB
     * @return B
     */
    protected String extractDecrementIndex(String node) {
        return extractIncrementIndex(node, -1);
    }

    /**
     * MapIuWFNgǂfB
     * @param node XPath̃m[hB
     * @return MapȂtrueAȊOfalseԂB
     */
    protected boolean isMapAttribute(String node) {
        // '[@name'Map
        if (node.indexOf("[@name") != -1) {
            return true;
        }
        return false;
    }

    /**
     * MapIuWFNgǂfB
     * @param node XPath̃m[hB
     * @return MapIuWFNgȂtrueAȊOfalseԂB
     */
    protected boolean isMapObject(String node) {
        // '.[@name'cŎn܂ȂMapIuWFNg
        if (node.startsWith(".[@name")) {
            return true;
        }
        return false;
    }
}
