/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.partition;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import jp.terasoluna.fw.batch.core.JobManager;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.core.WorkQueue;
import jp.terasoluna.fw.batch.core.WorkQueueFactory;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

/**
 * <p>WuɂāAqWu𑽏dxPŒs邽߂̃Wu}l[W
 * BsĂqWûǂꂩrŏIꍇɁAc̎qWu
 * sɃWu~B</p>
 * 
 * <p>ƏIɁÃWu}l[W̃WuXe[^XIԂłƂ
 * eWũWuXe[^X̃WuƓWuXe[^XɍXVB</p>
 * 
 */
public class SequentialChildJobManager extends JobManager {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(SequentialChildJobManager.class);

    /**
     * ƃL[̃t@NgB
     */
    private WorkQueueFactory workQueueFactory = null;

    /**
     * Wu}lW[B
     */
    private String name = null;

    /**
     * ThrowablenhB
     */
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler(); 

    /**
     * WuOsT|[gvZbTB
     */
    private SupportProcessor preProcessor = null;

    /**
     * Wu㏈sT|[gvZbTB
     */
    private SupportProcessor postProcessor = null;

    
    /**
     * ƂsB<BR>
     * JobManagerNXƈႢOĂ^[R[hZbgB
     *
     * @param workUnit ƒP
     * @param jobStatus WuXe[^X
     */
    public void work(WorkUnit workUnit, JobStatus jobStatus) {
        JobStatus childJobStatus = null;
        childJobStatus = jobStatus.getChild(workUnit.getJobContext());
        boolean finish_flag = true;
        try {
            //JnO
            writeStartLog(childJobStatus);
            
            preProcessor.process(workUnit.getJobContext(), childJobStatus);
            if (!childJobStatus.isContinue()) {
                finish_flag = false;
                return;
            }
            
            // {
            WorkQueue managerQueue = workQueueFactory.getWorkQueue(childJobStatus);
            
            processCollect(workUnit.getJobContext(), managerQueue, childJobStatus);
            
            managerQueue.waitForAllWorkers();
            
            postProcessor.process(workUnit.getJobContext(), childJobStatus);
                        
        }  catch (Throwable throwable) {
            throwableHandler.handle(workUnit.getJobContext(), throwable, childJobStatus);
        } finally {
            //^[R[hݒ
            if(finish_flag) {
                finishWork(jobStatus, childJobStatus);
            }
            //IO
            writeEndLog(childJobStatus);
        }
    }
    
    /**
     * ƏIsB
     * 
     * @param parentJobStatus ÑWuXe[^X
     * @param jobStatus ̃Wu}l[W̃WuXe[^X
     */
    protected void finishWork(
            JobStatus parentJobStatus, JobStatus jobStatus) {
        if (jobStatus.isExecuting()) {
            jobStatus.setJobState(JobStatus.STATE.ENDING_NORMALLY);
        } else if (jobStatus.isShutdownGraceful() 
                || jobStatus.isShutdownImmediate()) {
            jobStatus.suspend();
            parentJobStatus.setJobState(jobStatus.getJobState());
        } else {
            parentJobStatus.setJobState(jobStatus.getJobState());
        }
    }

    /**
     * ƃL[̃t@Ngݒ肷B
     *
     * @param workQueueFactory ƃL[̃t@Ng
     */
    public void setWorkQueueFactory(WorkQueueFactory workQueueFactory) {
        this.workQueueFactory = workQueueFactory;
    }

    /**
     * Wu}lW[ݒ肷B
     *
     * @param name Wu}lW[
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Throwablenhݒ肷B
     * 
     * @param throwableHandler Throwablenh
     */
    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
    /**
     * Wu㏈sT|[gvZbTݒ肷B
     *
     * @param postProcessor Wu㏈sT|[gvZbT
     */
    public void setPostProcessor(SupportProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    /**
     * WuOsT|[gvZbTݒ肷B
     *
     * @param preProcessor WuOsT|[gvZbT
     */
    public void setPreProcessor(SupportProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }
    
    /**
     * JobManager̊JnOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeStartLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Job processing START: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [partitionKey=");
            logStr.append(jobStatus.getPartitionKey());
            logStr.append("] [JobManagerName=");
            logStr.append(name);
            logStr.append("] [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.info(logStr.toString());
        }
    }

    /**
     * JobManageȑIOo͂B
     * 
     * @param jobStatus WuXe[^X
     */
    private void writeEndLog(JobStatus jobStatus) {
        if (log.isInfoEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Job processing END: [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [partitionKey=");
            logStr.append(jobStatus.getPartitionKey());
            logStr.append("] [JobManagerName=");
            logStr.append(name);
            logStr.append("] [JobState=");
            logStr.append(jobStatus.getJobState());
            logStr.append("]");
            log.info(logStr.toString());
        }
    }
}
