/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.valang.predicates;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.AnyPredicate;
import org.apache.commons.collections.functors.FalsePredicate;
import org.springframework.util.StringUtils;
import org.springmodules.validation.valang.ValangException;
import org.springmodules.validation.valang.functions.Function;
import org.springmodules.validation.valang.functions.LiteralFunction;
import org.springmodules.validation.valang.predicates.AbstractPropertyPredicate;
import org.springmodules.validation.valang.predicates.Operator;
import org.springmodules.validation.valang.predicates.OperatorConstants;

public class GenericTestPredicate
extends AbstractPropertyPredicate {
    public GenericTestPredicate(Function leftFunction, Operator operator, Function rightFunction, int line, int column) {
        super(leftFunction, operator, rightFunction, line, column);
    }

    public boolean evaluate(Object target) {
        Object leftValue = this.getLeftFunction().getResult(target);
        Object rightValue = null;
        boolean dates = false;
        boolean numbers = false;
        if (this.getRightFunction() != null) {
            rightValue = this.getRightFunction().getResult(target);
        }
        if (leftValue instanceof Number) {
            leftValue = new BigDecimal(leftValue.toString());
        }
        if (rightValue instanceof Number) {
            rightValue = new BigDecimal(rightValue.toString());
        }
        dates = leftValue instanceof Date && rightValue instanceof Date;
        boolean bl = numbers = leftValue instanceof BigDecimal && rightValue instanceof BigDecimal;
        if (this.getOperator() instanceof Operator.NullOperator) {
            return leftValue == null;
        }
        if (this.getOperator() instanceof Operator.NotNullOperator) {
            return leftValue != null;
        }
        if (this.getOperator() instanceof Operator.EqualsOperator) {
            if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
                return ((BigDecimal)leftValue).compareTo((BigDecimal)rightValue) == 0;
            }
            if (dates) {
                return ((Date)leftValue).getTime() == ((Date)rightValue).getTime();
            }
            return leftValue.equals(rightValue);
        }
        if (this.getOperator() instanceof Operator.NotEqualsOperator) {
            if (leftValue instanceof BigDecimal && rightValue instanceof BigDecimal) {
                return ((BigDecimal)leftValue).compareTo((BigDecimal)rightValue) != 0;
            }
            if (dates) {
                return ((Date)leftValue).getTime() != ((Date)rightValue).getTime();
            }
            return !leftValue.equals(rightValue);
        }
        if (this.getOperator() instanceof Operator.LessThanOperator) {
            if (dates) {
                return ((Date)leftValue).getTime() < ((Date)rightValue).getTime();
            }
            if (numbers) {
                return ((BigDecimal)leftValue).compareTo((BigDecimal)rightValue) < 0;
            }
            throw new ValangException("< operator only supports two date or two number values!", this.getLine(), this.getColumn());
        }
        if (this.getOperator() instanceof Operator.LessThanOrEqualOperator) {
            if (dates) {
                return ((Date)leftValue).getTime() <= ((Date)rightValue).getTime();
            }
            if (numbers) {
                return ((BigDecimal)leftValue).compareTo((BigDecimal)rightValue) <= 0;
            }
            throw new ValangException("<= operator only supports two date or two number values!", this.getLine(), this.getColumn());
        }
        if (this.getOperator() instanceof Operator.MoreThanOperator) {
            if (dates) {
                return ((Date)leftValue).getTime() > ((Date)rightValue).getTime();
            }
            if (numbers) {
                return ((BigDecimal)leftValue).compareTo((BigDecimal)rightValue) > 0;
            }
            throw new ValangException("> operator only supports two date or two number values!", this.getLine(), this.getColumn());
        }
        if (this.getOperator() instanceof Operator.MoreThanOrEqualOperator) {
            if (dates) {
                return ((Date)leftValue).getTime() >= ((Date)rightValue).getTime();
            }
            if (numbers) {
                return ((BigDecimal)leftValue).compareTo((BigDecimal)rightValue) >= 0;
            }
            throw new IllegalArgumentException(">= operator only supports two date or two number values!");
        }
        if (this.getOperator() instanceof Operator.InOperator) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Iterator iter = this.getIterator(rightValue);
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof Function) {
                    predicates.add(this.getPredicate(new LiteralFunction(leftValue), OperatorConstants.EQUALS_OPERATOR, (Function)o, this.getLine(), this.getColumn()));
                    continue;
                }
                predicates.add(this.getPredicate(new LiteralFunction(leftValue), OperatorConstants.EQUALS_OPERATOR, new LiteralFunction(o), this.getLine(), this.getColumn()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalStateException("IN expression contains no elements!");
            }
            if (predicates.size() == 1) {
                predicates.add(FalsePredicate.getInstance());
            }
            return AnyPredicate.getInstance(predicates).evaluate(target);
        }
        if (this.getOperator() instanceof Operator.NotInOperator) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            Iterator iter = this.getIterator(rightValue);
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof Function) {
                    predicates.add(this.getPredicate(new LiteralFunction(leftValue), OperatorConstants.EQUALS_OPERATOR, (Function)o, this.getLine(), this.getColumn()));
                    continue;
                }
                predicates.add(this.getPredicate(new LiteralFunction(leftValue), OperatorConstants.EQUALS_OPERATOR, new LiteralFunction(o), this.getLine(), this.getColumn()));
            }
            if (predicates.isEmpty()) {
                throw new IllegalStateException("NOT IN expression contains no elements!");
            }
            if (predicates.size() == 1) {
                predicates.add(FalsePredicate.getInstance());
            }
            return !AnyPredicate.getInstance(predicates).evaluate(target);
        }
        if (this.getOperator() instanceof Operator.BetweenOperator) {
            Object[] array = this.getArray(rightValue);
            Predicate predicate1 = this.getPredicate(new LiteralFunction(leftValue), OperatorConstants.MORE_THAN_OR_EQUAL_OPERATOR, (Function)array[0], this.getLine(), this.getColumn());
            Predicate predicate2 = this.getPredicate(new LiteralFunction(leftValue), OperatorConstants.LESS_THAN_OR_EQUAL_OPERATOR, (Function)array[1], this.getLine(), this.getColumn());
            return AndPredicate.getInstance((Predicate)predicate1, (Predicate)predicate2).evaluate(target);
        }
        if (this.getOperator() instanceof Operator.NotBetweenOperator) {
            Predicate predicate2;
            Object[] array = this.getArray(rightValue);
            Predicate predicate1 = this.getPredicate(new LiteralFunction(leftValue), OperatorConstants.MORE_THAN_OR_EQUAL_OPERATOR, (Function)array[0], this.getLine(), this.getColumn());
            return !AndPredicate.getInstance((Predicate)predicate1, (Predicate)(predicate2 = this.getPredicate(new LiteralFunction(leftValue), OperatorConstants.LESS_THAN_OR_EQUAL_OPERATOR, (Function)array[1], this.getLine(), this.getColumn()))).evaluate(target);
        }
        if (this.getOperator() instanceof Operator.HasLengthOperator) {
            return StringUtils.hasLength((String)(leftValue != null ? leftValue.toString() : null));
        }
        if (this.getOperator() instanceof Operator.HasNoLengthOperator) {
            return !StringUtils.hasLength((String)(leftValue != null ? leftValue.toString() : null));
        }
        if (this.getOperator() instanceof Operator.HasTextOperator) {
            return StringUtils.hasText((String)(leftValue != null ? leftValue.toString() : null));
        }
        if (this.getOperator() instanceof Operator.HasNoTextOperator) {
            return !StringUtils.hasText((String)(leftValue != null ? leftValue.toString() : null));
        }
        if (this.getOperator() instanceof Operator.IsBlankOperator) {
            return this.isBlank(leftValue != null ? leftValue.toString() : null);
        }
        if (this.getOperator() instanceof Operator.IsNotBlankOperator) {
            return !this.isBlank(leftValue != null ? leftValue.toString() : null);
        }
        if (this.getOperator() instanceof Operator.IsWordOperator) {
            return this.isWord(leftValue != null ? leftValue.toString() : null);
        }
        if (this.getOperator() instanceof Operator.IsNotWordOperator) {
            return !this.isWord(leftValue != null ? leftValue.toString() : null);
        }
        if (this.getOperator() instanceof Operator.IsLowerCaseOperator) {
            return this.isLowerCase(leftValue != null ? leftValue.toString() : null);
        }
        if (this.getOperator() instanceof Operator.IsNotLowerCaseOperator) {
            return !this.isLowerCase(leftValue != null ? leftValue.toString() : null);
        }
        if (this.getOperator() instanceof Operator.IsUpperCaseOperator) {
            return this.isUpperCase(leftValue != null ? leftValue.toString() : null);
        }
        if (this.getOperator() instanceof Operator.IsNotUpperCaseOperator) {
            return !this.isUpperCase(leftValue != null ? leftValue.toString() : null);
        }
        throw new IllegalStateException("Operator class [" + this.getOperator().getClass().getName() + "] not supported!");
    }

    protected Predicate getPredicate(Function leftFunction, Operator operator, Function rightFunction, int line, int column) {
        return new GenericTestPredicate(leftFunction, operator, rightFunction, line, column);
    }

    private boolean isWord(String s) {
        return s != null && s.length() > 0 && this.deleteWhitespace(s).equals(s);
    }

    private boolean isLowerCase(String s) {
        return s.length() > 0 && s.toLowerCase().equals(s);
    }

    private boolean isUpperCase(String s) {
        return s.length() > 0 && s.toUpperCase().equals(s);
    }

    private boolean isBlank(String s) {
        return s == null || s.length() == 0;
    }

    private String deleteWhitespace(String s) {
        return StringUtils.deleteAny((String)s, (String)" \t\r\n\b");
    }
}

