/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.restart;

import java.util.List;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.SupportProcessor;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.SupportLogic;
import jp.terasoluna.fw.batch.restart.JobRestartTableHandler;
import jp.terasoluna.fw.batch.standard.ThrowBatchSystemErrorThrowableHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestartPostProcessor
implements SupportProcessor {
    private JobRestartTableHandler jobRestartTableHandler = null;
    private SupportProcessor postProcessor = null;
    private List<SupportLogic<JobContext>> supportLogicList = null;
    private String sqlKey = null;
    private boolean parentManager = false;
    private ThrowableHandler throwableHandler = new ThrowBatchSystemErrorThrowableHandler();

    @Override
    public void process(JobContext jobContext, JobStatus jobStatus) {
        try {
            this.postProcessor.process(jobContext, jobStatus);
            if (!this.isAbendOrSuspending(jobStatus) && (this.parentManager || this.supportLogicList != null && this.supportLogicList.size() > 0)) {
                this.jobRestartTableHandler.restartPointClear(jobStatus, this.sqlKey);
            }
        }
        catch (Throwable throwable) {
            this.throwableHandler.handle(jobContext, throwable, jobStatus);
        }
    }

    public void setJobRestartTableHandler(JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    @Override
    public boolean canSkip() {
        return false;
    }

    public void setPostProcessor(SupportProcessor postProcessor) {
        this.postProcessor = postProcessor;
    }

    public void setSupportLogicList(List<SupportLogic<JobContext>> supportLogicList) {
        this.supportLogicList = supportLogicList;
    }

    public void setSqlKey(String sqlKey) {
        this.sqlKey = sqlKey;
    }

    public void setParentManager(boolean parentManager) {
        this.parentManager = parentManager;
    }

    private boolean isAbendOrSuspending(JobStatus jobStatus) {
        if (jobStatus.getJobState() == JobStatus.STATE.ENDING_ABNORMALLY || jobStatus.getJobState() == JobStatus.STATE.SUSPENDING) {
            return true;
        }
        List<JobStatus> childJobStatusList = jobStatus.getChildJobStatusList();
        if (childJobStatusList != null) {
            for (JobStatus childJobStatus : childJobStatusList) {
                if (!this.isAbendOrSuspending(childJobStatus)) continue;
                return true;
            }
        }
        return false;
    }

    public void setThrowableHandler(ThrowableHandler throwableHandler) {
        this.throwableHandler = throwableHandler;
    }
}

