/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample004;

import java.util.Date;

import jp.terasoluna.fw.file.annotation.FileFormat;
import jp.terasoluna.fw.file.annotation.InputFileColumn;
import jp.terasoluna.fw.file.annotation.OutputFileColumn;

/**
 * õp[^NXB
 */
@FileFormat(overWriteFlg=true, headerLineCount=3, trailerLineCount=2, lineFeedChar = "\n", encloseChar='\"')
public class Sample004NyusyukkinData02 {

    /**
     * ID
     */
    @InputFileColumn(columnIndex = 0)
    @OutputFileColumn(columnIndex = 0)
    private String id;
   
    /**
     * oR[h
     */
    @InputFileColumn(columnIndex = 1)
    @OutputFileColumn(columnIndex = 1)
    private String nyusyukkincd;
    
    /**
     * R[h
     */
    @InputFileColumn(columnIndex = 2)
    @OutputFileColumn(columnIndex = 2)
    private String torihikicd;
    
    /**
     * xXR[h
     */
    private String sitencd;
    
    /**
     * ڋqR[h
     */
    @InputFileColumn(columnIndex = 3)
    @OutputFileColumn(columnIndex = 3)
    private String kokyakucd;
    
    /**
     * z
     */
    @InputFileColumn(columnIndex = 4)
    @OutputFileColumn(columnIndex = 4)
    private String kingaku;
    
    /**
     * 
     */
    @InputFileColumn(columnIndex = 5, columnFormat="yyyyMMdd")
    @OutputFileColumn(columnIndex = 5)
    private String torihikibi;
    
    /**
     * IDԋpB
     * @return ID
     */
    public String getId() {
        return id;
    }
    
    /**
     * IDݒ肷B
     * @param id ݒ肷ID
     */
    public void setId(String id) {
        this.id = id;
    }
    
    /**
     * oR[hԋpB
     * @return oR[h
     */
    public String getNyusyukkincd() {
        return nyusyukkincd;
    }
    
    /**
     * oR[hݒ肷B
     * @param nyusyukkincd oR[h
     */
    public void setNyusyukkincd(String nyusyukkincd) {
        this.nyusyukkincd = nyusyukkincd;
    }
    
    /**
     * R[hԋpB
     * @return R[h
     */
    public String getTorihikicd() {
        return torihikicd;
    }
    
    /**
     * R[hݒ肷B
     * @param torihikicd R[h
     */
    public void setTorihikicd(String torihikicd) {
        this.torihikicd = torihikicd;
    }
    
    /**
     * xXR[hԋpB
     * @return xXR[h
     */
    public String getSitencd() {
        return sitencd;
    }
    
    /**
     * xXR[hݒ肷B
     * @param sitencd ݒ肷xXR[h
     */
    public void setSitencd(String sitencd) {
        this.sitencd = sitencd;
    }
 
    
    /**
     * ڋqR[hԋpB
     * @return ڋqR[h
     */
    public String getKokyakucd() {
        return kokyakucd;
    }
    
    /**
     * ڋqR[hݒ肷B
     * @param kokyakucd ݒ肷ڋqR[h
     */
    public void setKokyakucd(String kokyakucd) {
        this.kokyakucd = kokyakucd;
    }
    
    /**
     * zԋpB
     * @return z
     */
    public String getKingaku() {
        return kingaku;
    }
    
    /**
     * zݒ肷B
     * @param kingaku ݒ肷z
     */
    public void setKingaku(String kingaku) {
        this.kingaku = kingaku;
    }
    
    /**
     * ԋpB
     * @return 
     */
    public String getTorihikibi() {
        return torihikibi;
    }
    
    /**
     * ݒ肷B
     * @param torihikibi 
     */
    public void setTorihikibi(String torihikibi) {
        this.torihikibi = torihikibi;
    }
}
