/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.collector;

import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;

import org.springframework.validation.Validator;

/**
 * AbstractCollectorݒ荀
 */
public class AbstractCollectorConfig {
    /** L[TCY */
    protected int queueSize = AbstractCollector.DEFAULT_QUEUE_SIZE;

    /** CollectorExceptionHandler */
    protected CollectorExceptionHandler exceptionHandler = null;

    /** Validator */
    protected Validator validator = null;

    /** ValidationErrorHandler */
    protected ValidationErrorHandler validationErrorHandler = null;

    /**
     * L[TCY擾B
     * @return L[TCY
     */
    public int getQueueSize() {
        return queueSize;
    }

    /**
     * L[TCYݒ肷B
     * @param queueSize L[TCY
     */
    public void setQueueSize(int queueSize) {
        this.queueSize = queueSize;
    }

    /**
     * CollectorExceptionHandler擾B
     * @return CollectorExceptionHandler
     */
    public CollectorExceptionHandler getExceptionHandler() {
        return exceptionHandler;
    }

    /**
     * CollectorExceptionHandlerݒ肷B
     * @param exceptionHandler CollectorExceptionHandler
     */
    public void setExceptionHandler(CollectorExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    /**
     * Validator擾B
     * @return Validator
     */
    public Validator getValidator() {
        return validator;
    }

    /**
     * Validatorݒ肷B
     * @param validator Validator
     */
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    /**
     * ValidationErrorHandler擾B
     * @return ValidationErrorHandler
     */
    public ValidationErrorHandler getValidationErrorHandler() {
        return validationErrorHandler;
    }

    /**
     * ValidationErrorHandlerݒ肷B
     * @param validationErrorHandler ValidationErrorHandler
     */
    public void setValidationErrorHandler(
            ValidationErrorHandler validationErrorHandler) {
        this.validationErrorHandler = validationErrorHandler;
    }
}
