/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.file;

import jp.terasoluna.fw.collector.AbstractCollector;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.file.FileCollectorConfig;
import jp.terasoluna.fw.collector.vo.DataValueObject;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;
import jp.terasoluna.fw.logger.TLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCollector<P>
extends AbstractCollector<P> {
    private static TLogger LOGGER = TLogger.getLogger(FileCollector.class);
    protected FileQueryDAO fileQueryDAO = null;
    protected String fileName = null;
    protected Class<P> clazz = null;

    protected FileCollector() {
    }

    public FileCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz));
    }

    public FileCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz, CollectorExceptionHandler exceptionHandler) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz).addExceptionHandler(exceptionHandler));
    }

    public FileCollector(FileQueryDAO fileQueryDAO, String fileName, Class<P> clazz, int queueSize, CollectorExceptionHandler exceptionHandler) {
        this(new FileCollectorConfig<P>(fileQueryDAO, fileName, clazz).addQueueSize(queueSize).addExceptionHandler(exceptionHandler));
    }

    public FileCollector(FileCollectorConfig<P> config) {
        if (config == null) {
            throw new IllegalArgumentException("The parameter is null.");
        }
        this.fileQueryDAO = config.getFileQueryDAO();
        this.fileName = config.getFileName();
        this.clazz = config.getClazz();
        if (config.getQueueSize() > 0) {
            this.setQueueSize(config.getQueueSize());
        }
        this.exceptionHandler = config.getExceptionHandler();
        this.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer call() throws Exception {
        block28: {
            FileLineIterator fli = null;
            long dataCount = 0L;
            try {
                fli = this.fileQueryDAO.execute(this.fileName, this.clazz);
                if (fli == null) break block28;
                while (fli.hasNext()) {
                    ++dataCount;
                    try {
                        Object value = fli.next();
                        this.addQueue(new DataValueObject(value, dataCount));
                    }
                    catch (InterruptedException e) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("TAL041002", new Object[]{Thread.currentThread().getName()});
                        }
                        break;
                    }
                    catch (Throwable e) {
                        try {
                            this.addQueue(new DataValueObject(e));
                        }
                        catch (InterruptedException ie) {
                            LOGGER.warn("WAL041003", e);
                            LOGGER.warn("WAL041003", (Throwable)ie);
                            break;
                        }
                    }
                }
            }
            catch (Throwable e) {
                try {
                    this.addQueue(new DataValueObject(e));
                }
                catch (InterruptedException ie) {
                    LOGGER.warn("WAL041003", e);
                    LOGGER.warn("WAL041003", (Throwable)ie);
                }
                Integer n = -1;
                return n;
            }
            finally {
                try {
                    if (fli != null) {
                        fli.closeFile();
                    }
                }
                catch (Throwable e) {
                }
                finally {
                    this.setFinish();
                }
            }
        }
        return 0;
    }
}

