/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.collector.db;

import jp.terasoluna.fw.collector.AbstractCollectorConfig;
import jp.terasoluna.fw.collector.db.DBCollectorPostprocess;
import jp.terasoluna.fw.collector.db.DBCollectorPreprocess;
import jp.terasoluna.fw.collector.exception.CollectorExceptionHandler;
import jp.terasoluna.fw.collector.validate.ValidationErrorHandler;
import jp.terasoluna.fw.dao.QueryRowHandleDAO;
import org.springframework.validation.Validator;

public class DBCollectorConfig
extends AbstractCollectorConfig {
    protected QueryRowHandleDAO queryRowHandleDAO = null;
    protected String sqlID = null;
    protected Object bindParams = null;
    protected boolean relation1n = false;
    protected DBCollectorPreprocess dbCollectorPreprocess = null;
    protected DBCollectorPostprocess dbCollectorPostprocess = null;

    public DBCollectorConfig(QueryRowHandleDAO queryRowHandleDAO, String sqlID, Object bindParams) {
        this.queryRowHandleDAO = queryRowHandleDAO;
        this.sqlID = sqlID;
        this.bindParams = bindParams;
    }

    public DBCollectorConfig addQueueSize(int queueSize) {
        this.setQueueSize(queueSize);
        return this;
    }

    public DBCollectorConfig addExceptionHandler(CollectorExceptionHandler exceptionHandler) {
        this.setExceptionHandler(exceptionHandler);
        return this;
    }

    public DBCollectorConfig addValidator(Validator validator) {
        this.setValidator(validator);
        return this;
    }

    public DBCollectorConfig addValidationErrorHandler(ValidationErrorHandler validationErrorHandler) {
        this.setValidationErrorHandler(validationErrorHandler);
        return this;
    }

    public DBCollectorConfig addRelation1n(boolean relation1n) {
        this.setRelation1n(relation1n);
        return this;
    }

    public DBCollectorConfig addDBCollectorPreprocess(DBCollectorPreprocess dbCollectorPreprocess) {
        this.setDbCollectorPreprocess(dbCollectorPreprocess);
        return this;
    }

    public DBCollectorConfig addDBCollectorPostprocess(DBCollectorPostprocess dbCollectorPostprocess) {
        this.setDbCollectorPostprocess(dbCollectorPostprocess);
        return this;
    }

    public QueryRowHandleDAO getQueryRowHandleDAO() {
        return this.queryRowHandleDAO;
    }

    public void setQueryRowHandleDAO(QueryRowHandleDAO queryRowHandleDAO) {
        this.queryRowHandleDAO = queryRowHandleDAO;
    }

    public String getSqlID() {
        return this.sqlID;
    }

    public void setSqlID(String sqlID) {
        this.sqlID = sqlID;
    }

    public Object getBindParams() {
        return this.bindParams;
    }

    public void setBindParams(Object bindParams) {
        this.bindParams = bindParams;
    }

    public boolean isRelation1n() {
        return this.relation1n;
    }

    public void setRelation1n(boolean relation1n) {
        this.relation1n = relation1n;
    }

    public DBCollectorPreprocess getDbCollectorPreprocess() {
        return this.dbCollectorPreprocess;
    }

    public void setDbCollectorPreprocess(DBCollectorPreprocess dbCollectorPreprocess) {
        this.dbCollectorPreprocess = dbCollectorPreprocess;
    }

    public DBCollectorPostprocess getDbCollectorPostprocess() {
        return this.dbCollectorPostprocess;
    }

    public void setDbCollectorPostprocess(DBCollectorPostprocess dbCollectorPostprocess) {
        this.dbCollectorPostprocess = dbCollectorPostprocess;
    }
}

