/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.executor;

import java.io.File;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import jp.terasoluna.fw.batch.executor.AbstractJobBatchExecutor;
import jp.terasoluna.fw.batch.executor.concurrent.BatchServant;
import jp.terasoluna.fw.batch.executor.vo.BatchJobListResult;
import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.batch.util.JobUtil;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.logger.TLogger;
import jp.terasoluna.fw.util.PropertyUtil;
import org.apache.commons.logging.Log;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.dao.DataAccessException;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.transaction.PlatformTransactionManager;

public class AsyncBatchExecutor
extends AbstractJobBatchExecutor {
    private static final TLogger LOGGER = TLogger.getLogger(AsyncBatchExecutor.class);
    private static final String BATCH_TASK_EXECUTOR = "batchTaskExecutor.default";
    private static final String BATCH_TASK_SERVANT = "batchTaskExecutor.batchServant";
    private static final String BATCH_DB_ABNORMAL_RETRY_MAX = "batchTaskExecutor.dbAbnormalRetryMax";
    private static final String BATCH_DB_ABNORMAL_RETRY_INTERVAL = "batchTaskExecutor.dbAbnormalRetryInterval";
    private static final String BATCH_DB_ABNORMAL_RETRY_RESET = "batchTaskExecutor.dbAbnormalRetryReset";
    private static final long BATCH_DB_ABNORMAL_RETRY_MAX_DEFAULT = 0L;
    private static final long BATCH_DB_ABNORMAL_RETRY_INTERVAL_DEFAULT = 20000L;
    private static final long BATCH_DB_ABNORMAL_RETRY_RESET_DEFAULT = 600000L;
    private static final int PROCESS_END_STATUS_NORMAL = 0;
    private static final int PROCESS_END_STATUS_FAILURE = 255;
    public static final String THREAD_GROUP_PREFIX = AsyncBatchExecutor.class.getSimpleName() + "ThreadGroup";
    public static final String THREAD_NAME_PREFIX = AsyncBatchExecutor.class.getSimpleName() + "Thread";
    public static final String THREAD_GROUP_SEPARATOR = "-";
    public static final String THREAD_NAME_SEPARATOR = "-";
    private static AtomicInteger threadGroupNo = new AtomicInteger(0);

    protected AsyncBatchExecutor() {
    }

    public static void main(String[] args) {
        long retryCount = 0L;
        long retryCountMax = 0L;
        long retryCountReset = 600000L;
        long retryInterval = 20000L;
        int status = 255;
        long lastExceptionTime = System.currentTimeMillis();
        String dbAbnormalRetryMaxStr = PropertyUtil.getProperty((String)BATCH_DB_ABNORMAL_RETRY_MAX);
        String dbAbnormalRetryIntervalStr = PropertyUtil.getProperty((String)BATCH_DB_ABNORMAL_RETRY_INTERVAL);
        String dbAbnormalRetryResetStr = PropertyUtil.getProperty((String)BATCH_DB_ABNORMAL_RETRY_RESET);
        if (dbAbnormalRetryMaxStr != null && dbAbnormalRetryMaxStr.length() != 0) {
            try {
                retryCountMax = Long.parseLong(dbAbnormalRetryMaxStr);
            }
            catch (NumberFormatException e) {
                LOGGER.error("EAL025046", (Throwable)e, new Object[]{BATCH_DB_ABNORMAL_RETRY_MAX, dbAbnormalRetryMaxStr});
                System.exit(status);
                return;
            }
        }
        if (dbAbnormalRetryIntervalStr != null && dbAbnormalRetryIntervalStr.length() != 0) {
            try {
                retryInterval = Long.parseLong(dbAbnormalRetryIntervalStr);
            }
            catch (NumberFormatException e) {
                LOGGER.error("EAL025046", (Throwable)e, new Object[]{BATCH_DB_ABNORMAL_RETRY_INTERVAL, dbAbnormalRetryIntervalStr});
                System.exit(status);
                return;
            }
        }
        if (dbAbnormalRetryResetStr != null && dbAbnormalRetryResetStr.length() != 0) {
            try {
                retryCountReset = Long.parseLong(dbAbnormalRetryResetStr);
            }
            catch (NumberFormatException e) {
                LOGGER.error("EAL025046", (Throwable)e, new Object[]{BATCH_DB_ABNORMAL_RETRY_RESET, dbAbnormalRetryResetStr});
                System.exit(status);
                return;
            }
        }
        while (true) {
            try {
                status = AsyncBatchExecutor.executorMain(args);
            }
            catch (DataAccessException e) {
                if (System.currentTimeMillis() - lastExceptionTime > retryCountReset) {
                    retryCount = 0L;
                }
                lastExceptionTime = System.currentTimeMillis();
                if (retryCount >= retryCountMax) {
                    LOGGER.error("EAL025031", (Throwable)e);
                    break;
                }
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                LOGGER.info("IAL025017", new Object[]{++retryCount, retryCountMax, retryCountReset, retryInterval});
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("TAL025010", new Object[]{BatchUtil.getMemoryInfo()});
                continue;
            }
            break;
        }
        System.exit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int executorMain(String[] args) {
        Throwable throwable;
        int status;
        block47: {
            AsyncBatchExecutor executor;
            QueryDAO queryDAO;
            status = 255;
            throwable = null;
            String jobAppCd = null;
            String batchTaskExecutorName = null;
            String batchTaskServantName = null;
            ThreadPoolTaskExecutor taskExecutor = null;
            LOGGER.info("IAL025005");
            if (args.length > 0) {
                jobAppCd = args[0];
            }
            if ((jobAppCd == null || jobAppCd.length() == 0) && (jobAppCd = JobUtil.getenv("JOB_APP_CD")) != null && jobAppCd.length() == 0) {
                jobAppCd = null;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("IAL025006", new Object[]{jobAppCd == null ? "" : jobAppCd});
            }
            if ((queryDAO = (executor = new AsyncBatchExecutor()).getSysQueryDAO()) == null) {
                LOGGER.info("IAL025007");
                return status;
            }
            UpdateDAO updateDAO = executor.getSysUpdateDAO();
            if (updateDAO == null) {
                LOGGER.info("IAL025008");
                return status;
            }
            PlatformTransactionManager transactionManager = executor.getSysTransactionManager();
            if (transactionManager == null) {
                LOGGER.info("IAL025016");
                return status;
            }
            batchTaskExecutorName = PropertyUtil.getProperty((String)BATCH_TASK_EXECUTOR);
            batchTaskServantName = PropertyUtil.getProperty((String)BATCH_TASK_SERVANT);
            ApplicationContext ctx = executor.getDefaultApplicationContext();
            if (ctx != null && ctx.containsBean(batchTaskExecutorName)) {
                Object batchTaskExecutorObj = null;
                try {
                    batchTaskExecutorObj = ctx.getBean(batchTaskExecutorName, ThreadPoolTaskExecutor.class);
                }
                catch (Throwable e) {
                    LOGGER.error("EAL025029", e, new Object[]{batchTaskExecutorName});
                }
                if (batchTaskExecutorObj instanceof ThreadPoolTaskExecutor) {
                    taskExecutor = (ThreadPoolTaskExecutor)batchTaskExecutorObj;
                }
            }
            if (taskExecutor == null) {
                LOGGER.info("IAL025009");
                return status;
            }
            try {
                try {
                    while (true) {
                        BatchJobListResult batchJobListResult;
                        List<BatchJobListResult> jobList = null;
                        if (AsyncBatchExecutor.checkTaskQueue(taskExecutor)) {
                            jobList = jobAppCd == null ? JobUtil.selectJobList(queryDAO, 0, 1) : JobUtil.selectJobList(jobAppCd, queryDAO, 0, 1);
                        }
                        if (jobList != null && !jobList.isEmpty() && (batchJobListResult = jobList.get(0)) != null) {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("DAL025026", new Object[]{batchJobListResult.getJobSequenceId()});
                            }
                            if (LOGGER.isDebugEnabled()) {
                                AsyncBatchExecutor.logOutputTaskExecutor((Log)LOGGER, taskExecutor);
                            }
                            if (AsyncBatchExecutor.checkTaskQueue(taskExecutor)) {
                                BatchServant job = null;
                                if (ctx != null) {
                                    try {
                                        job = (BatchServant)ctx.getBean(batchTaskServantName, BatchServant.class);
                                    }
                                    catch (Throwable e) {
                                        LOGGER.error("EAL025030", e, new Object[]{batchTaskServantName});
                                        break;
                                    }
                                }
                                if (job == null) {
                                    LOGGER.error("EAL025030", new Object[]{batchTaskServantName});
                                    break;
                                }
                                boolean st = executor.startBatchStatus(batchJobListResult.getJobSequenceId(), queryDAO, updateDAO, transactionManager);
                                if (st) {
                                    job.setJobSequenceId(batchJobListResult.getJobSequenceId());
                                    if (LOGGER.isDebugEnabled()) {
                                        StringBuilder tgn = new StringBuilder();
                                        tgn.append(THREAD_GROUP_PREFIX);
                                        tgn.append("-");
                                        tgn.append(threadGroupNo.incrementAndGet());
                                        taskExecutor.setThreadGroupName(tgn.toString());
                                        StringBuilder tn = new StringBuilder();
                                        tn.append(THREAD_NAME_PREFIX);
                                        tn.append("-");
                                        tn.append(threadGroupNo.get());
                                        tn.append("-");
                                        taskExecutor.setThreadNamePrefix(tn.toString());
                                        LOGGER.debug("DAL025027", new Object[]{tgn.toString(), tn.toString()});
                                    }
                                    taskExecutor.execute((Runnable)job);
                                } else if (LOGGER.isInfoEnabled()) {
                                    LOGGER.info("IAL025010", new Object[]{batchJobListResult.getJobSequenceId()});
                                }
                            }
                        }
                        if (AsyncBatchExecutor.checkEndFile(executor.getExecutorEndMonitoringFile())) {
                            LOGGER.info("IAL025011");
                            break;
                        }
                        if ((jobList == null || jobList.size() == 0) && executor.getJobIntervalTime() >= 0L) {
                            try {
                                Thread.sleep(executor.getJobIntervalTime());
                            }
                            catch (InterruptedException e) {
                                if (!LOGGER.isInfoEnabled()) break;
                                LOGGER.info("IAL025012", new Object[]{e.getMessage()});
                                break;
                            }
                        }
                        if (!LOGGER.isTraceEnabled()) continue;
                        LOGGER.trace("TAL025010", new Object[]{BatchUtil.getMemoryInfo()});
                    }
                    Object var19_22 = null;
                }
                catch (Throwable e) {
                    throwable = e;
                    Object var19_23 = null;
                    LOGGER.debug("DAL025028");
                    taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
                    LOGGER.debug("DAL025029");
                    taskExecutor.shutdown();
                    LOGGER.debug("DAL025030");
                    while (taskExecutor.getActiveCount() != 0) {
                        try {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("DAL025031", new Object[]{taskExecutor.getActiveCount()});
                            }
                            Thread.sleep(executor.getExecutorJobTerminateWaitIntervalTime());
                        }
                        catch (InterruptedException e2) {}
                    }
                    AsyncBatchExecutor.closeRootApplicationContext(ctx);
                    break block47;
                }
            }
            catch (Throwable throwable2) {
                Object var19_24 = null;
                LOGGER.debug("DAL025028");
                taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
                LOGGER.debug("DAL025029");
                taskExecutor.shutdown();
                LOGGER.debug("DAL025030");
                while (true) {
                    if (taskExecutor.getActiveCount() == 0) {
                        AsyncBatchExecutor.closeRootApplicationContext(ctx);
                        throw throwable2;
                    }
                    try {}
                    catch (InterruptedException e2) {}
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("DAL025031", new Object[]{taskExecutor.getActiveCount()});
                    }
                    Thread.sleep(executor.getExecutorJobTerminateWaitIntervalTime());
                }
            }
            LOGGER.debug("DAL025028");
            taskExecutor.setWaitForTasksToCompleteOnShutdown(true);
            LOGGER.debug("DAL025029");
            taskExecutor.shutdown();
            LOGGER.debug("DAL025030");
            while (taskExecutor.getActiveCount() != 0) {
                try {}
                catch (InterruptedException e2) {}
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("DAL025031", new Object[]{taskExecutor.getActiveCount()});
                }
                Thread.sleep(executor.getExecutorJobTerminateWaitIntervalTime());
            }
            AsyncBatchExecutor.closeRootApplicationContext(ctx);
        }
        if (throwable == null) {
            LOGGER.info("IAL025013");
            return 0;
        }
        Throwable cause = throwable.getCause();
        if (cause instanceof DataAccessException) {
            throw (DataAccessException)cause;
        }
        LOGGER.error("EAL025031", throwable);
        return status;
    }

    protected static boolean checkTaskQueue(ThreadPoolTaskExecutor taskExecutor) {
        if (taskExecutor.getActiveCount() < taskExecutor.getMaxPoolSize()) {
            return true;
        }
        return taskExecutor.getThreadPoolExecutor().getQueue().remainingCapacity() > 0;
    }

    protected static boolean checkEndFile(String endFilePath) {
        if (endFilePath != null && endFilePath.length() != 0) {
            File endFile = new File(endFilePath);
            return endFile.exists();
        }
        return false;
    }

    protected static void logOutputTaskExecutor(Log log, ThreadPoolTaskExecutor taskExec) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("DAL025032", new Object[]{taskExec.getActiveCount(), taskExec.getCorePoolSize(), taskExec.getMaxPoolSize(), taskExec.getPoolSize(), taskExec.getThreadPoolExecutor().getActiveCount(), taskExec.getThreadPoolExecutor().getTaskCount(), taskExec.getThreadPoolExecutor().getQueue().size(), taskExec.getThreadPoolExecutor().getQueue().remainingCapacity()});
        }
    }

    protected static void closeRootApplicationContext(ApplicationContext context) {
        if (context instanceof AbstractApplicationContext) {
            AbstractApplicationContext aac = (AbstractApplicationContext)context;
            aac.close();
            aac.destroy();
        }
    }
}

