/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.validation.bean.rule;

import org.springmodules.validation.bean.rule.ValidationRule;
import org.springmodules.validation.bean.rule.resolver.ErrorArgumentsResolver;
import org.springmodules.validation.bean.rule.resolver.StaticErrorArgumentsResolver;
import org.springmodules.validation.util.condition.Condition;
import org.springmodules.validation.util.condition.common.AlwaysTrueCondition;

public class DefaultValidationRule
implements ValidationRule {
    private static final Condition DEFAULT_APPLICABILITY_CONDITION = new AlwaysTrueCondition();
    private Condition condition;
    private Condition applicabilityCondition;
    private String errorCode;
    private String defalutErrorMessage;
    private ErrorArgumentsResolver errorArgumentsResolver;

    public DefaultValidationRule() {
        this(null, null);
    }

    public DefaultValidationRule(Condition condition, String errorCode) {
        this(condition, DEFAULT_APPLICABILITY_CONDITION, errorCode, errorCode, new Object[0]);
    }

    public DefaultValidationRule(Condition condition, String errorCode, Object[] errorArguments) {
        this(condition, DEFAULT_APPLICABILITY_CONDITION, errorCode, errorCode, errorArguments);
    }

    public DefaultValidationRule(Condition condition, String errorCode, String defalutErrorMessage, Object[] errorArguments) {
        this(condition, DEFAULT_APPLICABILITY_CONDITION, errorCode, defalutErrorMessage, errorArguments);
    }

    public DefaultValidationRule(Condition condition, Condition applicabilityCondition, String errorCode) {
        this(condition, applicabilityCondition, errorCode, errorCode, new Object[0]);
    }

    public DefaultValidationRule(Condition condition, Condition applicabilityCondition, String errorCode, Object[] errorArguments) {
        this(condition, applicabilityCondition, errorCode, errorCode, errorArguments);
    }

    public DefaultValidationRule(Condition condition, Condition applicabilityCondition, String errorCode, String defalutErrorMessage, Object[] errorArguments) {
        this(condition, applicabilityCondition, errorCode, defalutErrorMessage, new StaticErrorArgumentsResolver(errorArguments));
    }

    public DefaultValidationRule(Condition condition, Condition applicabilityCondition, String errorCode, String defalutErrorMessage, ErrorArgumentsResolver errorArgumentsResolver) {
        this.condition = condition;
        this.applicabilityCondition = applicabilityCondition;
        this.errorCode = errorCode;
        this.errorArgumentsResolver = errorArgumentsResolver;
        this.defalutErrorMessage = defalutErrorMessage;
    }

    public boolean isApplicable(Object obj) {
        return this.applicabilityCondition.check(obj);
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Object[] getErrorArguments(Object obj) {
        return this.errorArgumentsResolver.resolveArguments(obj);
    }

    public void setErrorArguments(Object[] errorArguments) {
        this.errorArgumentsResolver = new StaticErrorArgumentsResolver(errorArguments);
    }

    public void setErrorArgumentsResolver(ErrorArgumentsResolver errorArgumentsResolver) {
        this.errorArgumentsResolver = errorArgumentsResolver;
    }

    public String getDefaultErrorMessage() {
        return this.defalutErrorMessage;
    }

    public void setDefalutErrorMessage(String defalutErrorMessage) {
        this.defalutErrorMessage = defalutErrorMessage;
    }

    public Condition getApplicabilityCondition() {
        return this.applicabilityCondition;
    }

    public void setApplicabilityCondition(Condition applicabilityCondition) {
        this.applicabilityCondition = applicabilityCondition;
    }
}

