/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import jp.terasoluna.fw.batch.util.FastFileUtility;
import jp.terasoluna.fw.ex.unit.util.AssertUtils;
import jp.terasoluna.fw.file.dao.FileException;
import junit.framework.TestCase;

/**
 * OFeeXg\bhƂ̑OmF邱
 */
public class FastFileUtilityTest extends TestCase {

	/**
	 * testCopyFile01()<br>
	 * <br>
	 * OԁFC\tmpztest01.txt݂邱ƁB<br>
	 * <br>
	 * eXgTvFt@Cǂݍ܂AɃRs[邱ƂmFB<br>
	 * <br>
	 * mFځFRs[̃t@CRs[ƓemFB<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCopyFile01() throws Exception {

		// eXgf[^ݒ
		String srcFile = "C:\\tmp\\test01.txt";
		String newFile = "C:\\tmp\\test01A.txt";

		// eXg{
		FastFileUtility.copyFile(srcFile, newFile);

		// ʌ
		File expected = new File(srcFile);
		File actual = new File(newFile);
		
		AssertUtils.assertFileEquals(expected, actual);
	}

	/**
	 * testCopyFile02()<br>
	 * <br>
	 * OԁFC\tmpztest02.txt݂ȂƁB<br>
	 * <br>
	 * eXgTvFt@Cǂݍ܂ꂸAFileExceptionX[邱ƂmFB<br>
	 * <br>
	 * mFځFFileExceptionX[邱ƁB<br>
	 * <br>
	 * mFځFOɁuC:\\tmp\\test02.txt is not exist.vbZ[Wݒ肳Ă邱ƁB<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCopyFile02() throws Exception {

		String srcFile = "C:\\tmp\\test02.txt";
		String newFile = "C:\\tmp\\test02A.txt";

		try {
			FastFileUtility.copyFile(srcFile, newFile);
			fail();
		} catch (FileException e) {
			assertEquals("C:\\tmp\\test02.txt is not exist.", e.getMessage());
		}
	}

	/**
	 * testCopyFile03()<br>
	 * <br>
	 * OԁFC\tmpztest03.txt݂Aǂݎ茠Ȃ<br>
	 * <br>
	 * eXgTvFt@Cǂݍ܂ꂸAFileExceptionX[邱ƂmFB<br>
	 * <br>
	 * mFځFFileExceptionX[邱ƁB<br>
	 * <br>
	 * mFځFOɁuFile control operation was failed.vbZ[Wݒ肳Ă邱ƁB<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCopyFile03() throws Exception {

		String srcFile = "C:\\tmp\\test03.txt";
		String newFile = "C:\\tmp\\test03A.txt";

		try {
			FastFileUtility.copyFile(srcFile, newFile);
			fail();
		} catch (FileException e) {
			assertEquals("File control operation was failed.", e.getMessage());
		}
	}

	/**
	 * testCopyFile04()<br>
	 * <br>
	 * OԁFȂ<br>
	 * <br>
	 * eXgTvFsrcFilenullݒ肵ꍇAt@Cǂݍ܂ꂸAFileExceptionX[邱ƂmFB<br>
	 * <br>
	 * mFځFFileExceptionX[邱ƁB<br>
	 * <br>
	 * mFځFOɁuFile control operation was failed.vbZ[Wݒ肳Ă邱ƁB<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCopyFile04() throws Exception {

		String srcFile = null;
		String newFile = "C:\\tmp\\test04A.txt";

		try {
			FastFileUtility.copyFile(srcFile, newFile);
			fail();
		} catch (FileException e) {
		}
	}

	/**
	 * testCopyFile05()<br>
	 * <br>
	 * OԁFȂ<br>
	 * <br>
	 * eXgTvFC\tmpztest01.txt݂AnewFilenullݒ肳ꂽꍇA
	 * FileExceptionX[邱ƂmFB<br>
	 * <br>
	 * mFځFFileExceptionX[邱ƁB<br>
	 * <br>
	 * mFځFOɁuFile control operation was failed.vbZ[Wݒ肳Ă邱ƁB<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCopyFile05() throws Exception {

		// eXgf[^ݒ
		String srcFile = "C:\\tmp\\test01.txt";
		String newFile = null;

		try {
			FastFileUtility.copyFile(srcFile, newFile);
			fail();
		} catch (FileException e) {
		}
	}

	/**
	 * testCopyFile06()<br>
	 * <br>
	 * OԁFC\tmpzɗeʂ̑傫test06.txt邱<br>
	 * <br>
	 * eXgTvFt@Cǂݍ܂AɃRs[邱ƂmFB<br>
	 * <br>
	 * mFځFRs[̃t@CRs[ƓemFB<br>
	 * <br>
	 * 
	 * @throws Exception
	 */
	public void testCopyFile06() throws Exception {

		// eXgf[^ݒ
		String srcFile = "C:\\tmp\\test06.txt";
		String newFile = "C:\\tmp\\test06A.txt";

		// eXg{
		FastFileUtility.copyFile(srcFile, newFile);

		// ʌ
		File expected = new File(srcFile);
		File actual = new File(newFile);
		
		AssertUtils.assertFileEquals(expected, actual);

	}

}
