/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.dao.support;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.fail;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Map.Entry;

import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.ex.unit.mock.DaoParam;
import jp.terasoluna.fw.ex.unit.mock.MockUpdateDao;
import jp.terasoluna.utlib.UTUtil;

import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class BatchUpdateSupportImplTest {

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    /**
     * testBatchUpdateSupportImpl001
     */
    @Test
    public void testBatchUpdateSupportImpl001() {
        BatchUpdateSupportImpl busi = null;

        // eXg
        try {
            busi = new BatchUpdateSupportImpl();
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // 
        assertNotNull(busi);
    }

    /**
     * testBatchUpdateSupportImplUpdateDAO001
     */
    @Test
    public void testBatchUpdateSupportImplUpdateDAO001() {
        BatchUpdateSupportImpl busi = null;
        UpdateDAO updateDAO = null;

        // eXg
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // 
        assertNotNull(busi);
    }

    /**
     * testBatchUpdateSupportImplUpdateDAO002
     */
    @Test
    public void testBatchUpdateSupportImplUpdateDAO002() {
        BatchUpdateSupportImpl busi = null;
        UpdateDAO updateDAO = new MockUpdateDao();

        // eXg
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // 
        assertNotNull(busi);
        Object updateDAOField = null;
        try {
            updateDAOField = UTUtil.getPrivateField(busi, "updateDAO");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
            fail();
        }
        assertEquals(updateDAO, updateDAOField);
    }

    /**
     * testAddBatch001
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testAddBatch001() {
        BatchUpdateSupportImpl busi = null;
        UpdateDAO updateDAO = new MockUpdateDao();

        // p[^ݒ
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // eXg
        try {
            busi.addBatch(null, null);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // 
        Map<String, Queue<SqlHolder>> batchSqlsMap = null;
        try {
            batchSqlsMap = (Map<String, Queue<SqlHolder>>) UTUtil
                    .getPrivateField(busi, "batchSqlsMap");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
            fail();
        }
        assertEquals(0, batchSqlsMap.size());
    }

    /**
     * testAddBatch002
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testAddBatch002() {
        BatchUpdateSupportImpl busi = null;
        UpdateDAO updateDAO = new MockUpdateDao();

        // p[^ݒ
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // eXg
        try {
            busi.addBatch("", null);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // 
        Map<String, Queue<SqlHolder>> batchSqlsMap = null;
        try {
            batchSqlsMap = (Map<String, Queue<SqlHolder>>) UTUtil
                    .getPrivateField(busi, "batchSqlsMap");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
            fail();
        }
        assertEquals(0, batchSqlsMap.size());
    }

    /**
     * testAddBatch003
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testAddBatch003() {
        BatchUpdateSupportImpl busi = null;
        UpdateDAO updateDAO = new MockUpdateDao();

        // p[^ݒ
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // eXg
        String sqlId1 = "hogeSQL";
        try {
            busi.addBatch(sqlId1, null);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // 
        Map<String, Queue<SqlHolder>> batchSqlsMap = null;
        try {
            batchSqlsMap = (Map<String, Queue<SqlHolder>>) UTUtil
                    .getPrivateField(busi, "batchSqlsMap");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
            fail();
        }
        assertEquals(1, batchSqlsMap.size());
        Set<Entry<String, Queue<SqlHolder>>> es = batchSqlsMap.entrySet();
        Entry et = es.toArray(new Entry[0])[0];
        assertEquals(sqlId1, et.getKey());
    }

    /**
     * testAddBatch004
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testAddBatch004() {
        BatchUpdateSupportImpl busi = null;
        UpdateDAO updateDAO = new MockUpdateDao();

        // p[^ݒ
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // eXg
        String sqlId1 = "hogeSQL";
        try {
            busi.addBatch(sqlId1, null);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // 
        Map<String, Queue<SqlHolder>> batchSqlsMap = null;
        try {
            batchSqlsMap = (Map<String, Queue<SqlHolder>>) UTUtil
                    .getPrivateField(busi, "batchSqlsMap");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
            fail();
        }
        assertEquals(1, batchSqlsMap.size());
        Set<Entry<String, Queue<SqlHolder>>> es = batchSqlsMap.entrySet();
        Entry et = es.toArray(new Entry[0])[0];
        assertEquals(sqlId1, et.getKey());
        assertNotNull(et.getValue());
        assertEquals(sqlId1, ((SqlHolder) ((Queue) et.getValue())
                .toArray(new SqlHolder[0])[0]).getSqlID());
        assertEquals(null, ((SqlHolder) ((Queue) et.getValue())
                .toArray(new SqlHolder[0])[0]).getBindParams());
    }

    /**
     * testAddBatch005
     */
    @SuppressWarnings("unchecked")
    @Test
    public void testAddBatch005() {
        BatchUpdateSupportImpl busi = null;
        UpdateDAO updateDAO = new MockUpdateDao();

        // p[^ݒ
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // eXg
        String sqlId1 = "hogeSQL";
        DummyParam dummyParam1 = new DummyParam();
        try {
            busi.addBatch(sqlId1, dummyParam1);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        // 
        Map<String, Queue<SqlHolder>> batchSqlsMap = null;
        try {
            batchSqlsMap = (Map<String, Queue<SqlHolder>>) UTUtil
                    .getPrivateField(busi, "batchSqlsMap");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
            fail();
        }
        assertEquals(1, batchSqlsMap.size());
        Set<Entry<String, Queue<SqlHolder>>> es = batchSqlsMap.entrySet();
        Entry et = es.toArray(new Entry[0])[0];
        assertEquals(sqlId1, et.getKey());
        assertNotNull(et.getValue());
        assertEquals(sqlId1, ((SqlHolder) ((Queue) et.getValue())
                .toArray(new SqlHolder[0])[0]).getSqlID());
        assertEquals(dummyParam1, ((SqlHolder) ((Queue) et.getValue())
                .toArray(new SqlHolder[0])[0]).getBindParams());
    }

    /**
     * testExecuteBatch001
     */
    @Test
    public void testExecuteBatch001() {
        BatchUpdateSupportImpl busi = null;
        MockUpdateDao updateDAO = new MockUpdateDao();

        // p[^ݒ
        updateDAO.addResult(Integer.valueOf(0));
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        String sqlId1 = "hogeSQLc";
        DummyParamC dummyParam1 = new DummyParamC();
        String sqlId2 = "hogeSQLb";
        DummyParamB dummyParam2 = new DummyParamB();
        String sqlId3 = "hogeSQLb";
        DummyParamB dummyParam3 = new DummyParamB();
        String sqlId4 = "hogeSQLa";
        DummyParamA dummyParam4 = new DummyParamA();
        String sqlId5 = "hogeSQLa";
        DummyParamA dummyParam5 = new DummyParamA();

        busi.addBatch(sqlId1, dummyParam1);
        busi.addBatch(sqlId2, dummyParam2);
        busi.addBatch(sqlId3, dummyParam3);
        busi.addBatch(sqlId4, dummyParam4);
        busi.addBatch(sqlId5, dummyParam5);

        // eXg
        int result = busi.executeBatch();

        // 
        assertEquals(0, result);
        List<DaoParam> params = updateDAO.getParams();
        assertNotNull(params);
        assertEquals(5, params.size());
        // -- hogeSQLa
        assertEquals(sqlId4, params.get(0).getSqlId());
        assertEquals(dummyParam4, params.get(0).getBindParams());
        // -- hogeSQLa
        assertEquals(sqlId5, params.get(1).getSqlId());
        assertEquals(dummyParam5, params.get(1).getBindParams());
        // -- hogeSQLb
        assertEquals(sqlId2, params.get(2).getSqlId());
        assertEquals(dummyParam2, params.get(2).getBindParams());
        // -- hogeSQLb
        assertEquals(sqlId3, params.get(3).getSqlId());
        assertEquals(dummyParam3, params.get(3).getBindParams());
        // -- hogeSQLc
        assertEquals(sqlId1, params.get(4).getSqlId());
        assertEquals(dummyParam1, params.get(4).getBindParams());
        // --
    }

    /**
     * testExecuteBatchUpdateDAO001
     */
    @Test
    public void testExecuteBatchUpdateDAO001() {
        BatchUpdateSupportImpl busi = null;
        MockUpdateDao updateDAO = new MockUpdateDao();

        // p[^ݒ
        updateDAO.addResult(Integer.valueOf(0));
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        String sqlId1 = "hogeSQLc";
        DummyParamC dummyParam1 = new DummyParamC();
        String sqlId2 = "hogeSQLb";
        DummyParamB dummyParam2 = new DummyParamB();
        String sqlId3 = "hogeSQLb";
        DummyParamB dummyParam3 = new DummyParamB();
        String sqlId4 = "hogeSQLa";
        DummyParamA dummyParam4 = new DummyParamA();
        String sqlId5 = "hogeSQLa";
        DummyParamA dummyParam5 = new DummyParamA();

        busi.addBatch(sqlId1, dummyParam1);
        busi.addBatch(sqlId2, dummyParam2);
        busi.addBatch(sqlId3, dummyParam3);
        busi.addBatch(sqlId4, dummyParam4);
        busi.addBatch(sqlId5, dummyParam5);

        // eXg
        int result = busi.executeBatch((UpdateDAO) null);

        // 
        assertEquals(BatchUpdateSupport.ERROR_UPDATE_DAO_IS_NULL, result);
    }

    /**
     * testExecuteBatchUpdateDAO002
     */
    @Test
    public void testExecuteBatchUpdateDAO002() {
        BatchUpdateSupportImpl busi = null;
        MockUpdateDao updateDAO1 = new MockUpdateDao();
        MockUpdateDao updateDAO2 = new MockUpdateDao();

        // p[^ݒ
        updateDAO1.addResult(Integer.valueOf(-1));
        updateDAO2.addResult(Integer.valueOf(0));
        try {
            busi = new BatchUpdateSupportImpl(updateDAO1);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        String sqlId1 = "hogeSQLc";
        DummyParamC dummyParam1 = new DummyParamC();
        String sqlId2 = "hogeSQLb";
        DummyParamB dummyParam2 = new DummyParamB();
        String sqlId3 = "hogeSQLb";
        DummyParamB dummyParam3 = new DummyParamB();
        String sqlId4 = "hogeSQLa";
        DummyParamA dummyParam4 = new DummyParamA();
        String sqlId5 = "hogeSQLa";
        DummyParamA dummyParam5 = new DummyParamA();

        busi.addBatch(sqlId1, dummyParam1);
        busi.addBatch(sqlId2, dummyParam2);
        busi.addBatch(sqlId3, dummyParam3);
        busi.addBatch(sqlId4, dummyParam4);
        busi.addBatch(sqlId5, dummyParam5);

        // eXg
        int result = busi.executeBatch(updateDAO2);

        // 
        assertEquals(0, result);
        List<DaoParam> params = updateDAO2.getParams();
        assertNotNull(params);
        assertEquals(5, params.size());
        // -- hogeSQLa
        assertEquals(sqlId4, params.get(0).getSqlId());
        assertEquals(dummyParam4, params.get(0).getBindParams());
        // -- hogeSQLa
        assertEquals(sqlId5, params.get(1).getSqlId());
        assertEquals(dummyParam5, params.get(1).getBindParams());
        // -- hogeSQLb
        assertEquals(sqlId2, params.get(2).getSqlId());
        assertEquals(dummyParam2, params.get(2).getBindParams());
        // -- hogeSQLb
        assertEquals(sqlId3, params.get(3).getSqlId());
        assertEquals(dummyParam3, params.get(3).getBindParams());
        // -- hogeSQLc
        assertEquals(sqlId1, params.get(4).getSqlId());
        assertEquals(dummyParam1, params.get(4).getBindParams());
        // --
    }

    /**
     * testExecuteBatchUpdateDAO003
     */
    @Test
    public void testExecuteBatchUpdateDAO003() {
        BatchUpdateSupportImpl busi = null;
        MockUpdateDao updateDAO = new MockUpdateDao();

        // p[^ݒ
        updateDAO.addResult(Integer.valueOf(0));
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        String sqlId1 = "hogeSQLc";
        DummyParamC dummyParam1 = new DummyParamC();
        String sqlId2 = "hogeSQLb";
        DummyParamB dummyParam2 = new DummyParamB();
        String sqlId3 = "hogeSQLb";
        DummyParamB dummyParam3 = new DummyParamB();
        String sqlId4 = "hogeSQLa";
        DummyParamA dummyParam4 = new DummyParamA();
        String sqlId5 = "hogeSQLa";
        DummyParamA dummyParam5 = new DummyParamA();

        busi.addBatch(sqlId1, dummyParam1);
        busi.addBatch(sqlId2, dummyParam2);
        busi.addBatch(sqlId3, dummyParam3);
        busi.addBatch(sqlId4, dummyParam4);
        busi.addBatch(sqlId5, dummyParam5);

        // eXg
        int result = busi.executeBatch(updateDAO);

        // 
        assertEquals(0, result);
        List<DaoParam> params = updateDAO.getParams();
        assertNotNull(params);
        assertEquals(5, params.size());
        // -- hogeSQLa
        assertEquals(sqlId4, params.get(0).getSqlId());
        assertEquals(dummyParam4, params.get(0).getBindParams());
        // -- hogeSQLa
        assertEquals(sqlId5, params.get(1).getSqlId());
        assertEquals(dummyParam5, params.get(1).getBindParams());
        // -- hogeSQLb
        assertEquals(sqlId2, params.get(2).getSqlId());
        assertEquals(dummyParam2, params.get(2).getBindParams());
        // -- hogeSQLb
        assertEquals(sqlId3, params.get(3).getSqlId());
        assertEquals(dummyParam3, params.get(3).getBindParams());
        // -- hogeSQLc
        assertEquals(sqlId1, params.get(4).getSqlId());
        assertEquals(dummyParam1, params.get(4).getBindParams());
        // --
    }

    @SuppressWarnings("unchecked")
    @Test
    public void testClear001() {
        BatchUpdateSupportImpl busi = null;
        MockUpdateDao updateDAO = new MockUpdateDao();

        // p[^ݒ
        updateDAO.addResult(Integer.valueOf(0));
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        String sqlId1 = "hogeSQLc";
        DummyParamC dummyParam1 = new DummyParamC();
        String sqlId2 = "hogeSQLb";
        DummyParamB dummyParam2 = new DummyParamB();
        String sqlId3 = "hogeSQLb";
        DummyParamB dummyParam3 = new DummyParamB();
        String sqlId4 = "hogeSQLa";
        DummyParamA dummyParam4 = new DummyParamA();
        String sqlId5 = "hogeSQLa";
        DummyParamA dummyParam5 = new DummyParamA();

        busi.addBatch(sqlId1, dummyParam1);
        busi.addBatch(sqlId2, dummyParam2);
        busi.addBatch(sqlId3, dummyParam3);
        busi.addBatch(sqlId4, dummyParam4);
        busi.addBatch(sqlId5, dummyParam5);

        // eXg
        busi.clear();

        // 
        Map<String, Queue<SqlHolder>> batchSqlsMap = null;
        try {
            batchSqlsMap = (Map<String, Queue<SqlHolder>>) UTUtil
                    .getPrivateField(busi, "batchSqlsMap");
        } catch (NoSuchFieldException e) {
            e.printStackTrace();
            fail();
        }
        assertEquals(0, batchSqlsMap.size());
    }

    @Test
    public void testSize001() {
        BatchUpdateSupportImpl busi = null;
        MockUpdateDao updateDAO = new MockUpdateDao();

        // p[^ݒ
        updateDAO.addResult(Integer.valueOf(0));
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        String sqlId1 = "hogeSQLc";
        DummyParamC dummyParam1 = new DummyParamC();
        String sqlId2 = "hogeSQLb";
        DummyParamB dummyParam2 = new DummyParamB();
        String sqlId3 = "hogeSQLb";
        DummyParamB dummyParam3 = new DummyParamB();
        String sqlId4 = "hogeSQLa";
        DummyParamA dummyParam4 = new DummyParamA();
        String sqlId5 = "hogeSQLa";
        DummyParamA dummyParam5 = new DummyParamA();

        busi.addBatch(sqlId1, dummyParam1);
        busi.addBatch(sqlId2, dummyParam2);
        busi.addBatch(sqlId3, dummyParam3);
        busi.addBatch(sqlId4, dummyParam4);
        busi.addBatch(sqlId5, dummyParam5);

        // eXg
        long count = busi.size();

        // 
        assertEquals(5, count);
    }

    @Test
    public void testGetSqlHolderList001() {
        BatchUpdateSupportImpl busi = null;
        MockUpdateDao updateDAO = new MockUpdateDao();

        // p[^ݒ
        updateDAO.addResult(Integer.valueOf(0));
        try {
            busi = new BatchUpdateSupportImpl(updateDAO);
        } catch (Exception e) {
            e.printStackTrace();
            fail();
        }

        String sqlId1 = "hogeSQLc";
        DummyParamC dummyParam1 = new DummyParamC();
        String sqlId2 = "hogeSQLb";
        DummyParamB dummyParam2 = new DummyParamB();
        String sqlId3 = "hogeSQLb";
        DummyParamB dummyParam3 = new DummyParamB();
        String sqlId4 = "hogeSQLa";
        DummyParamA dummyParam4 = new DummyParamA();
        String sqlId5 = "hogeSQLa";
        DummyParamA dummyParam5 = new DummyParamA();

        busi.addBatch(sqlId1, dummyParam1);
        busi.addBatch(sqlId2, dummyParam2);
        busi.addBatch(sqlId3, dummyParam3);
        busi.addBatch(sqlId4, dummyParam4);
        busi.addBatch(sqlId5, dummyParam5);

        // eXg
        List<SqlHolder> list = busi.getSqlHolderList();

        // 
        assertNotNull(list);
        assertEquals(5, list.size());
        assertEquals(sqlId4, list.get(0).getSqlID());
        assertEquals(sqlId5, list.get(1).getSqlID());
        assertEquals(sqlId2, list.get(2).getSqlID());
        assertEquals(sqlId3, list.get(3).getSqlID());
        assertEquals(sqlId1, list.get(4).getSqlID());
    }

}
