/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.util.Map;

import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;

/**
 * t@CݗpFileLineWriterNXB
 * <p>
 * t@CANZX(f[^)s3̃NX(CSVAŒ蒷Aϒ) ɋʂ鏈܂Ƃ߂ۃNXB t@C̎ނɑΉTuNXsB<br>
 * ݒ{@link jp.terasoluna.fw.file.dao.FileUpdateDAO}QƂ̂ƁB
 * </p>
 * @see jp.terasoluna.fw.file.dao.FileUpdateDAO
 * @see jp.terasoluna.fw.file.dao.standard.CSVFileUpdateDAO
 * @see jp.terasoluna.fw.file.dao.standard.FixedFileUpdateDAO
 * @see jp.terasoluna.fw.file.dao.standard.VariableFileUpdateDAO
 * @see jp.terasoluna.fw.file.dao.standard.PlainFileUpdateDAO
 */
public abstract class AbstractFileUpdateDAO implements FileUpdateDAO {

    /**
     * tH[}bg}bvB
     */
    private Map<String, ColumnFormatter> columnFormatterMap = null;

    /**
     * t@Cw肵āA<code>FileLineWriter</code> 擾B
     * @param <T> 1s̕i[t@CsIuWFNgNX
     * @param fileName t@Ci΃pX܂͑΃pX̂ǂ炩j
     * @param clazz 1s̕i[t@CsIuWFNgNX
     * @return t@Co͗pWriter
     */
    public abstract <T> FileLineWriter<T> execute(String fileName,
            Class<T> clazz);

    /**
     * tH[}bg}bv擾B
     * @return tH[}bg}bv
     */
    public Map<String, ColumnFormatter> getColumnFormatterMap() {
        return columnFormatterMap;
    }

    /**
     * tH[}bg}bvݒ肷B
     * @param columnFormatterMap tH[}bg}bv
     */
    public void setColumnFormatterMap(
            Map<String, ColumnFormatter> columnFormatterMap) {
        this.columnFormatterMap = columnFormatterMap;
    }
}
