/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.util;

import jp.terasoluna.fw.batch.message.MessageAccessor;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * bZ[WǗ[eBeBB<br>
 * <br>
 * bZ[W̊ǗsꍇɗpB
 */
public class MessageUtil {

    /**
     * O.
     */
    private static Log log = LogFactory.getLog(MessageUtil.class);

    /**
     * bZ[W\[XANZT.
     */
    private static final ThreadLocal<MessageAccessor> messageAccessorLocal = new ThreadLocal<MessageAccessor>();

    /**
     * bZ[W\[XANZTݒ肷.
     * @param messageAccessor
     */
    public static void setMessageAccessor(MessageAccessor messageAccessor) {
        messageAccessorLocal.set(messageAccessor);
    }

    /**
     * R[hɉbZ[Wԋp
     * @param errorCode R[h
     * @return R[hɉbZ[Wԋp
     */
    public static String getMessage(String code) {
        return getMessage(code, null);
    }

    /**
     * R[hɉbZ[Wԋp
     * @param errorCode R[h
     * @return R[hɉbZ[Wԋp
     */
    public static String getMessage(String code, Object[] args) {
        String mes = null;
        MessageAccessor ma = messageAccessorLocal.get();

        if (ma != null) {
            try {
                mes = ma.getMessage(code, args);
            } catch (Throwable e) {
                // Ȃ
            }
        } else {
            if (log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("MessageAccessor is not found.");
                log.debug(sb.toString());
            }
        }

        // bZ[WȂꍇ
        if (mes == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Message not found. CODE:[");
            sb.append(code);
            sb.append("]");
            return sb.toString();
        }

        return mes;
    }
}
