package jp.terasoluna.batch.functionsample.b001;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.Reader;

import jp.terasoluna.fw.batch.blogic.AbstractTransactionBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * DB֘AWũTv(Oracle)<br>
 * <br>
 * 
 * OFLOB_TABLEe[u쐬ĂƁB
 * CLOBTESTBLOBTESTt@Cc:\\tmptH_ɒuƁB<br>
 * <br>
 * TveFBLOB/CLOBɃt@C}TviOraclejB
 * 
 */
public class B001011BLogic extends AbstractTransactionBLogic {

	@Autowired
	@Qualifier("queryDAO2")
	private QueryDAO queryDAO = null;

	@Autowired
	@Qualifier("updateDAO2")
	private UpdateDAO updateDAO = null;

	@Override
	public int doMain(BLogicParam arg0) {

		B001011Param data = new B001011Param();
		B001011Param result = new B001011Param();
		updateDAO.execute("B001011.deleteLobTable", null);

		try {
			data.setId("0000001");

			Reader rd = new FileReader(new File("c:\\tmp\\CLOBTEST"));
			data.setClobData(rd);

			InputStream is = new FileInputStream(new File("c:\\tmp\\BLOBTEST"));
			data.setBlobData(is);

			// LOBf[^̑}
			updateDAO.execute("B001011.insertLobTable", data);

			// LOBf[^̎擾
			result = queryDAO.executeForObject("B001011.selectLobTable",
					"0000001", B001011Param.class);

			System.out.println(result.getId());
			System.out.println(result.getClobData());
			System.out.println(result.getBlobData());

		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return 0;
	}

}
