package jp.terasoluna.batch.functionsample.b001;

import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.dao.UpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

/**
 * DB֘AWũTv<br>
 * <br>
 * 
 * OFEMPLOYEEe[u쐬Ă<br>
 * <br>
 * TveFQƁEXVsBgUNVǗ̓rWlXWbNŐ䂷TvB
 */
public class B001002BLogic implements BLogic {

	private Log log = LogFactory.getLog(B001002BLogic.class);

	private static final int BATCH_NORMAL_END = 0;

	@Autowired
	@Qualifier("queryDAO")
	private QueryDAO queryDAO = null;

	@Autowired
	@Qualifier("updateDAO")
	private UpdateDAO updateDAO = null;

	@Autowired
	@Qualifier("transactionManager")
	private PlatformTransactionManager transactionManager = null;

	public int execute(BLogicParam arg0) {

		TransactionStatus stat = null;

		try {
			stat = BatchUtil.startTransaction(transactionManager);

			int count = queryDAO.executeForObject(
					"B001002.selectEmployeeCount", null, Integer.class);

			B001002Param newUser = new B001002Param();

			newUser.setId(count + 1);
			newUser.setFamilyName("Rc");
			newUser.setFirstName("Y");
			newUser.setAge(45);

			updateDAO.execute("B001002.insertEmployee", newUser);

			BatchUtil.commitTransaction(transactionManager, stat);

			log.info("ȉ̃[UEMPLOYEEe[uɒǉ܂");
			log.info("id : " + newUser.getId() + " familyName : "
					+ newUser.getFamilyName() + " firstName : "
					+ newUser.getFirstName() + " age : " + newUser.getAge());

		} finally {
			BatchUtil.endTransaction(transactionManager, stat);
		}

		return BATCH_NORMAL_END;

	}

}
