package jp.terasoluna.batch.functionsample.b000;

import java.io.File;

import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.file.util.FileControl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * t@C֘AWũTv<br>
 * <br>
 * 
 * OFC:\tmpzinput.csvt@Czu邱 <br>
 * <br>
 * TveF TERASOLUNA Batch Framework for
 * Javãt@CRs[@\𗘗pāAinput.csvt@Cresult2.csvɃRs[TvB
 * 
 * 
 * 
 */
public class B000002BLogic implements BLogic {

	private Log log = LogFactory.getLog(B000002BLogic.class);

	private static final int BATCH_NORMAL_END = 0;
	private static final int BATCH_ABNORMAL_END = 100;

	@Autowired
	@Qualifier("fileControl")
	private FileControl fileControl = null;

	public int execute(BLogicParam arg0) {

		String srcFile = "C:\\tmp\\input.csv";
		String copyFile = "C:\\tmp\\result2.csv";

		if (arg0 != null && arg0.getJobArgNm1() != null) {
			File f = new File(arg0.getJobArgNm1());
			if (f.exists()) {
				srcFile = arg0.getJobArgNm1();
			} else {
				return BATCH_ABNORMAL_END;
			}
		}

		if (arg0 != null && arg0.getJobArgNm2() != null) {
			copyFile = arg0.getJobArgNm2();
		}

		// t@C@\Bean`擾B
		fileControl.copyFile(srcFile, copyFile);

		log.info(copyFile + "쐬");

		// I
		return BATCH_NORMAL_END;
	}

}
