package jp.terasoluna.batch.functionsample.b000;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileQueryDAO;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;
import jp.terasoluna.fw.file.util.FileControl;

/**
 * t@C֘AWũTv<br>
 * <br>
 * 
 * OFC:\tmpzinput.csvt@Czu邱 <br>
 * <br>
 * TveF input.csvt@CǂݎAwb_ƃtb_ result.csvt@CoTvB
 * 
 * 
 */
public class B000001BLogic implements BLogic {

	private Log log = LogFactory.getLog(B000001BLogic.class);

	private static final int BATCH_NORMAL_END = 0;

	@Autowired
	@Qualifier("csvFileQueryDAO")
	private FileQueryDAO csvFileQueryDAO = null;

	@Autowired
	@Qualifier("csvFileUpdateDAO")
	private FileUpdateDAO csvFileUpdateDAO = null;

	@Autowired
	@Qualifier("fileControl")
	private FileControl fileControl = null;

	public int execute(BLogicParam arg0) {

		FileLineIterator<CsvRecord> recordIterator = csvFileQueryDAO.execute(
				"C:\\tmp\\input.csv", CsvRecord.class);

		FileLineWriter<CsvRecord> fileLineWriter = csvFileUpdateDAO.execute(
				"C:\\tmp\\result.csv", CsvRecord.class);

		List<String> header = new ArrayList<String>();
		header.add("header");
		List<String> footer = new ArrayList<String>();
		footer.add("footer");

		try {
			// wb_̏o
			fileLineWriter.printHeaderLine(header);

			while (recordIterator.hasNext()) {
				CsvRecord record = recordIterator.next();
				log.info("ID:" + record.getId() + " FIMILYNAME:"
						+ record.getFamilyName() + " FIRSTNAME:"
						+ record.getFirstName() + " AGE:" + record.getAge());

				// f[^̏o
				fileLineWriter.printDataLine(record);

			}
			// tb_̏o
			fileLineWriter.printTrailerLine(footer);
		} finally {
			// t@C̃N[Y
			recordIterator.closeFile();
			fileLineWriter.closeFile();
		}

		// I
		return BATCH_NORMAL_END;
	}

}
