/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.util.FileUtility;

public class FastFileUtility
extends FileUtility {
    public static void copyFile(String srcFile, String newFile) {
        if (srcFile == null) {
            throw new FileException("srcFile is null.");
        }
        if (newFile == null) {
            throw new FileException("newFile is null.");
        }
        File srcFileObject = new File(srcFile);
        if (!srcFileObject.exists()) {
            throw new FileException(String.valueOf(srcFile) + " is not exist.");
        }
        File outputFileObject = new File(newFile);
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel ic = null;
        AbstractInterruptibleChannel oc = null;
        try {
            try {
                fis = new FileInputStream(srcFileObject);
                fos = new FileOutputStream(outputFileObject);
                ic = fis.getChannel();
                oc = fos.getChannel();
                ((FileChannel)ic).transferTo(0L, ((FileChannel)ic).size(), (WritableByteChannel)((Object)oc));
            }
            catch (IOException e) {
                throw new FileException("File control operation was failed.", (Exception)e);
            }
        }
        finally {
            if (oc != null) {
                try {
                    oc.close();
                }
                catch (IOException iOException) {}
            }
            if (ic != null) {
                try {
                    ic.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

