/*
 * Copyright (c) 2011 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.dao.support;

import java.util.Comparator;
import java.util.List;

import jp.terasoluna.fw.dao.SqlHolder;
import jp.terasoluna.fw.dao.UpdateDAO;

/**
 * ob`XVT|[gC^tF[X<br>
 * @see UpdateDAO
 */
public interface BatchUpdateSupport {
    /** UpdateDAOnull̂Ƃ̃G[Xe[^X */
    int ERROR_UPDATE_DAO_IS_NULL = -100;

    /**
     * ob`spSQLǉB<br>
     * @param sqlID String
     * @param bindParams Object
     */
    void addBatch(final String sqlID, final Object bindParams);

    /**
     * ob`ssB<br>
     * <p>
     * ob`sꍇ́Ãob`sSQLXg̍폜sB
     * </p>
     * <p>
     * {\bhŎsꍇ́ARXgN^UpdateDAOnĂƁB<br>
     * UpdateDAORXgN^œnĂȂꍇ́A-100ԋpB
     * </p>
     * @return SQL̎s
     * @see UpdateDAO
     */
    int executeBatch();

    /**
     * ob`ssB<br>
     * <p>
     * ob`sꍇ́Ãob`sSQLXg̍폜sB
     * </p>
     * <p>
     * {\bhŎsꍇ́ARXgN^œnꂽUpdateDAO͎gpȂB<br>
     * UpdateDAOnull̏ꍇ́A-100ԋpB
     * </p>
     * @param updateDAO UpdateDAO
     * @return SQL̎s
     * @see UpdateDAO
     */
    int executeBatch(UpdateDAO updateDAO);

    /**
     * ob`ssB<br>
     * <p>
     * ob`sꍇ́Ãob`sSQLXg̍폜sB
     * </p>
     * <p>
     * {\bhŎsꍇ́ARXgN^œnꂽUpdateDAO͎gpȂB<br>
     * UpdateDAOnull̏ꍇ́A-100ԋpB
     * </p>
     * <p>
     * ComparatornƂɂSQL̕ёւ𐧌łB
     * </p>
     * @param updateDAO UpdateDAO
     * @param comparator Comparator&lt;String&gt;
     * @return SQL̎s
     * @see UpdateDAO
     */
    int executeBatch(UpdateDAO updateDAO, Comparator<String> comparator);

    /**
     * ob`sSQLXg̓e폜B<br>
     * <p>
     * ̃ob`sSQLXg̍폜sB
     * </p>
     */
    void clear();

    /**
     * ob`sSQLXg̓o^擾B<br>
     * @return ob`sSQLXg̓o^
     */
    long size();

    /**
     * SQL-IDŐ񂳂ꂽSqlHolderXg擾B<br>
     * <p>
     * ̃ob`sSQLXgSQL-IDɐ񂵂XgԋpB
     * </p>
     * <p>
     * {\bhsẴob`sSQLXg͍폜ȂB
     * </p>
     * @return SqlHolderXg
     */
    List<SqlHolder> getSqlHolderList();

    /**
     * SQL-IDŐ񂳂ꂽSqlHolderXg擾B<br>
     * <p>
     * ̃ob`sSQLXgSQL-IDɐ񂵂XgԋpB
     * </p>
     * <p>
     * {\bhsẴob`sSQLXg͍폜ȂB
     * </p>
     * <p>
     * ComparatornƂɂSQL̕ёւ𐧌łB
     * </p>
     * @param comparator Comparator&lt;String&gt;
     * @return SqlHolderXg
     */
    List<SqlHolder> getSqlHolderList(Comparator<String> comparator);

}
