/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.exception;

import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.batch.util.MessageUtil;

public class BatchException
extends RuntimeException {
    private static final long serialVersionUID = 7677068837918514733L;
    private String messageId = null;
    private Object[] params = null;

    public BatchException() {
    }

    public BatchException(String message) {
        super(message);
    }

    public BatchException(String message, Throwable cause) {
        super(message, cause);
    }

    public BatchException(Throwable cause) {
        super(cause);
    }

    public BatchException(String messageId, String message) {
        super(message);
        this.messageId = messageId;
    }

    public BatchException(String messageId, String message, Throwable cause) {
        super(message, cause);
        this.messageId = messageId;
    }

    public BatchException(String messageId, String message, Object ... params) {
        super(message);
        this.messageId = messageId;
        this.params = params;
    }

    public BatchException(String messageId, String message, Throwable cause, Object ... params) {
        super(message, cause);
        this.messageId = messageId;
        this.params = params;
    }

    public static BatchException createException(String messageId) {
        return new BatchException(messageId, MessageUtil.getMessage(messageId));
    }

    public static BatchException createException(String messageId, Object ... params) {
        return new BatchException(messageId, MessageUtil.getMessage(messageId, params), params);
    }

    public static BatchException createException(String messageId, Throwable cause) {
        return new BatchException(messageId, MessageUtil.getMessage(messageId), cause);
    }

    public static BatchException createException(String messageId, Throwable cause, Object ... params) {
        return new BatchException(messageId, MessageUtil.getMessage(messageId, params), cause, params);
    }

    public String getLogMessage() {
        StringBuilder logMsg = new StringBuilder();
        logMsg.append(BatchUtil.cat("[", this.messageId, "] ", this.getMessage()));
        if (this.params != null) {
            logMsg.append(" (\n");
            Object[] objectArray = this.params;
            int n = this.params.length;
            int n2 = 0;
            while (n2 < n) {
                Object option = objectArray[n2];
                logMsg.append(BatchUtil.cat("\t", option, "\n"));
                ++n2;
            }
            logMsg.append(")");
        }
        return logMsg.toString();
    }

    public String getMessageId() {
        return this.messageId;
    }
}

