/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.blogic;

import java.util.Map;
import jp.terasoluna.fw.batch.blogic.AbstractBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.util.BatchUtil;
import jp.terasoluna.fw.exception.SystemException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTransactionBLogic
extends AbstractBLogic {
    private static final int PROCESS_END_STATUS_FAILURE = 255;
    private static Log logging = LogFactory.getLog(AbstractTransactionBLogic.class);
    private Map<?, ?> transactionManagerMap = null;
    private Map<String, TransactionStatus> transactionStatusMap = null;

    @Override
    public int execute(BLogicParam param) {
        int status = 255;
        ApplicationContext ctx = this.getApplicationContext();
        this.transactionManagerMap = ctx.getBeansOfType(PlatformTransactionManager.class);
        this.transactionStatusMap = this.startTransactions(this.transactionManagerMap);
        try {
            try {
                status = this.doMain(param);
                this.commitTransactions(this.transactionManagerMap, this.transactionStatusMap);
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SystemException(e);
            }
        }
        finally {
            boolean et = this.endTransactions(this.transactionManagerMap, this.transactionStatusMap);
            if (!et && logging.isErrorEnabled()) {
                logging.error((Object)"At the end of the transaction error.");
            }
        }
        return status;
    }

    public abstract int doMain(BLogicParam var1);

    private Map<String, TransactionStatus> startTransactions(Map<?, ?> trnMngMap) {
        return BatchUtil.startTransactions(BatchUtil.getTransactionDefinition(), trnMngMap, logging);
    }

    private void commitTransactions(Map<?, ?> trnMngMap, Map<String, TransactionStatus> tranStatMap) {
        BatchUtil.commitTransactions(trnMngMap, tranStatMap, logging);
    }

    private boolean endTransactions(Map<?, ?> trnMngMap, Map<String, TransactionStatus> tranStatMap) {
        return BatchUtil.endTransactions(trnMngMap, tranStatMap, logging);
    }
}

