/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.util.FileControl;
import jp.terasoluna.fw.file.util.FileUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileControlImpl
implements FileControl {
    private String basePath = "";

    @Override
    public void copyFile(String srcFile, String newFile) {
        FileUtility.copyFile(this.getAbsolutePath(srcFile), this.getAbsolutePath(newFile));
    }

    @Override
    public void deleteFile(String srcFile) {
        FileUtility.deleteFile(this.getAbsolutePath(srcFile));
    }

    @Override
    public void mergeFile(List<String> fileList, String newFile) {
        ArrayList<String> srcFileList = new ArrayList<String>();
        for (String fileName : fileList) {
            srcFileList.add(this.getAbsolutePath(fileName));
        }
        FileUtility.mergeFile(srcFileList, this.getAbsolutePath(newFile));
    }

    @Override
    public void renameFile(String srcFile, String newFile) {
        FileUtility.renameFile(this.getAbsolutePath(srcFile), this.getAbsolutePath(newFile));
    }

    private String getAbsolutePath(String fileName) {
        if (fileName == null) {
            throw new FileException("File name is not set.", fileName);
        }
        File newFileObject = new File(fileName);
        if (!newFileObject.isAbsolute()) {
            StringBuilder newFilePath = new StringBuilder(this.basePath);
            return newFilePath.append(fileName).toString();
        }
        return fileName;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setCheckFileExist(boolean checkFileExist) {
        FileUtility.setCheckFileExist(checkFileExist);
    }
}

