/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;
import jp.terasoluna.fw.file.dao.FileException;
import jp.terasoluna.fw.file.dao.standard.LineReader;

public class EncloseCharLineFeed2LineReader
implements LineReader {
    private char delimiterCharacter = '\u0000';
    private char encloseCharacter = '\u0000';
    private char[] columnEncloseCharacter = null;
    private Reader reader = null;
    private String lineFeedChar = null;

    public EncloseCharLineFeed2LineReader(char delimiterCharacter, char encloseCharacter, char[] columnEncloseCharacter, Reader reader, String lineFeedChar) {
        if (delimiterCharacter == '\u0000') {
            throw new IllegalArgumentException("delimiterCharacter can not use '\\u0000'.");
        }
        if (columnEncloseCharacter == null) {
            throw new IllegalArgumentException("columnEncloseCharacter is required.");
        }
        if (reader == null) {
            throw new IllegalArgumentException("reader is required.");
        }
        if (lineFeedChar == null) {
            throw new IllegalArgumentException("lineFeedChar is required.");
        }
        if (lineFeedChar.length() != 2) {
            throw new IllegalArgumentException("lineFeedChar should be defined by 2 digit of character string.");
        }
        this.delimiterCharacter = delimiterCharacter;
        this.encloseCharacter = encloseCharacter;
        this.columnEncloseCharacter = columnEncloseCharacter;
        this.reader = reader;
        this.lineFeedChar = lineFeedChar;
    }

    public String readLine() {
        StringBuilder currentLineStringBuilder = new StringBuilder();
        char previousChar = '\u0000';
        char currentChar = '\u0000';
        boolean isEnclosed = true;
        boolean isEscape = false;
        char lineFeedChar1 = this.lineFeedChar.charAt(0);
        char lineFeedChar2 = this.lineFeedChar.charAt(1);
        int chr = 0;
        int fieldCount = 0;
        try {
            while ((chr = this.reader.read()) != -1) {
                currentChar = (char)chr;
                if (previousChar == '\u0000') {
                    previousChar = currentChar;
                }
                if (previousChar == this.getEncloseCharcter(fieldCount)) {
                    if (isEnclosed) {
                        if (currentChar != this.getEncloseCharcter(fieldCount)) continue;
                        isEnclosed = false;
                        currentLineStringBuilder.append(currentChar);
                        continue;
                    }
                    if (currentChar == this.getEncloseCharcter(fieldCount) && !isEscape) {
                        isEscape = true;
                        continue;
                    }
                    if (currentChar == this.getEncloseCharcter(fieldCount) && isEscape) {
                        isEscape = false;
                        currentLineStringBuilder.append(currentChar);
                        currentLineStringBuilder.append(currentChar);
                        continue;
                    }
                    if (currentChar == this.delimiterCharacter) {
                        if (isEscape) {
                            currentLineStringBuilder.append(this.getEncloseCharcter(fieldCount));
                            previousChar = '\u0000';
                            isEnclosed = true;
                            isEscape = false;
                            ++fieldCount;
                        }
                        currentLineStringBuilder.append(currentChar);
                        continue;
                    }
                    if (currentChar == lineFeedChar1) {
                        if (isEscape) {
                            currentLineStringBuilder.append(this.getEncloseCharcter(fieldCount));
                            previousChar = currentChar;
                            isEnclosed = true;
                            isEscape = false;
                        }
                        currentLineStringBuilder.append(currentChar);
                        continue;
                    }
                    if (isEscape) {
                        currentLineStringBuilder.append(this.getEncloseCharcter(fieldCount));
                        previousChar = currentChar;
                        isEnclosed = true;
                        isEscape = false;
                    }
                    currentLineStringBuilder.append(currentChar);
                    continue;
                }
                if (previousChar == lineFeedChar1) {
                    if (currentChar == lineFeedChar2 && currentLineStringBuilder.length() - 1 >= 0 && currentLineStringBuilder.charAt(currentLineStringBuilder.length() - 1) == lineFeedChar1) {
                        currentLineStringBuilder.deleteCharAt(currentLineStringBuilder.length() - 1);
                        previousChar = '\u0000';
                        isEnclosed = true;
                        isEscape = false;
                        break;
                    }
                    currentLineStringBuilder.append(currentChar);
                    continue;
                }
                if (currentChar == this.delimiterCharacter) {
                    currentLineStringBuilder.append(currentChar);
                    previousChar = '\u0000';
                    isEnclosed = true;
                    isEscape = false;
                    ++fieldCount;
                    continue;
                }
                if (currentChar == lineFeedChar2) {
                    if (currentLineStringBuilder.length() - 1 >= 0 && currentLineStringBuilder.charAt(currentLineStringBuilder.length() - 1) == lineFeedChar1) {
                        currentLineStringBuilder.deleteCharAt(currentLineStringBuilder.length() - 1);
                        previousChar = '\u0000';
                        isEnclosed = true;
                        isEscape = false;
                        break;
                    }
                    currentLineStringBuilder.append(currentChar);
                    continue;
                }
                currentLineStringBuilder.append(currentChar);
            }
        }
        catch (IOException e) {
            throw new FileException("Reader control operation was failed.", e);
        }
        return currentLineStringBuilder.toString();
    }

    private char getEncloseCharcter(int index) {
        if (this.columnEncloseCharacter.length == 0) {
            return this.encloseCharacter;
        }
        return this.columnEncloseCharacter[index];
    }
}

