/*
 * Copyright (c) 2011 NTT DATA Corporation
 */

package jp.terasoluna.batch.functionsample.b005;


import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

/**
 * Oo͂邽߂̃C^Zv^̊NXB
 * 
 * <p>
 * ReiBean̑ݎQƂ邽߁A 샍Oo̓NX𒼐ڐݒ(DI)ȂB
 * ڂ̎sɁAApplicationContext擾sB
 * </p>
 * 
 * 
 */
public abstract class LoggingInterceptor implements MethodInterceptor,
        ApplicationContextAware {
    /**
     * LogB
     */
    private static Log logger = LogFactory.getLog(LoggingInterceptor.class);

    /**
     * 샍OB
     */
    private OperationLogger operationLogger = null;

    /**
     * 샍OBeańB
     */
    private String operationLoggerBeanName = null;

    /**
     * AvP[VReLXgB
     */
    private ApplicationContext applicationContext = null;

    /**
     * 샍OBean̂ݒ肷B
     * 
     * @param operationLoggerBeanName 샍OBeańB
     */
    public void setOperationLoggerBeanName(String operationLoggerBeanName) {
        this.operationLoggerBeanName = operationLoggerBeanName;
    }

    /**
     * AvP[VReLXgݒ肷B
     * 
     * @param applicationContext AvP[VReLXg
     */
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    /**
     * MethodInvocation̏ꕔ񉻂B
     * 
     * @param invocation MethodInvocation
     * @return MethodInvocation̏ꕔ񉻂
     */
    protected String getInvocationDescription(MethodInvocation invocation) {
        return "method '" + invocation.getMethod().getName() + "' of class ["
                + invocation.getThis().getClass().getName() + "]";
    }

    /**
     * 샍Oo̓NX擾B
     * 
     * @return 샍Oo̓NX
     */
    protected OperationLogger getOperationLogger() {
        if (this.operationLogger == null) {
            try {
                this.operationLogger = (OperationLogger) applicationContext
                        .getBean(operationLoggerBeanName, OperationLogger.class);
            } catch (Exception e) {
                logger.error("logger bean not found.", e);
            }
        }
        return this.operationLogger;
    }

}
