/*
 * Copyright (c) 2011 NTT DATA Corporation
 */

package jp.terasoluna.batch.functionsample.b005;


import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ƖWbN̎sOEs Oo͂邽߂̃C^Zv^B
 * 
 * <p>
 * Oo͂̎́AOperationLoggersB
 * </p>
 * 
 * <p>
 * ̃C^Zv^̓KpύXꍇ́A
 * beanvf"blogicLoggingAutoProxy"ҏW邱ƁB
 * </p>
 * 
 */
public class BLogicLoggingInterceptor extends LoggingInterceptor {
    /**
     * LogB
     */
    private static Log logger = LogFactory
            .getLog(BLogicLoggingInterceptor.class);

    /**
     * ONX擾AOo͂̔sB
     * 
     * @param invocation {Ăяo郁\bh
     * @return {Ăяo郁\bȟ
     * @throws Throwable O
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        OperationLogger operationLogger = getOperationLogger();

        // JnȌo
        if (logger.isTraceEnabled()) {
            logger.trace("Start:" + getInvocationDescription(invocation));
        }

        // 샍O(Jn)̏o
        if (operationLogger != null) {
            try {
                operationLogger.logStartBLogic(invocation.getThis().getClass(),
                        invocation.getMethod(), invocation.getArguments());
            } catch (Throwable logEx) {
                // čOosɌxOo͂B
                logger.warn("Logging start BLogic failed.", logEx);
            }
        }

        try {
            // {Ăяo郁\bhĂяo
            Object rval = invocation.proceed();

            // IȌo
            if (logger.isTraceEnabled()) {
                logger.trace("End:" + getInvocationDescription(invocation));
            }

            // 샍O(I)̏o
            if (operationLogger != null) {
                try {
                    operationLogger.logEndBLogic(invocation.getThis()
                            .getClass(), invocation.getMethod(), invocation
                            .getArguments(), rval);
                } catch (Throwable logEx) {
                    // čOosɌxOo͂B
                    logger.warn("Logging end BLogic failed.", logEx);
                }
            }
            // ʂ̕ԋp
            return rval;

        } catch (Throwable ex) {
            // Oۂ̃Oo
            if (logger.isTraceEnabled()) {
                logger.trace("Exception thrown in:"
                        + getInvocationDescription(invocation), ex);
            }

            // 샍O(O)̏o
            if (operationLogger != null) {
                try {
                    operationLogger.logExceptionBLogic(invocation.getThis()
                            .getClass(), invocation.getMethod(), invocation
                            .getArguments(), ex);
                } catch (Throwable logEx) {
                    // čOosɌxOo͂B
                    logger.warn("Logging exception BLogic failed.", logEx);
                }
            }
            throw ex;
        }
    }

}
