package jp.terasoluna.batch.functionsample.b003;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;

import jp.terasoluna.fw.dao.QueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * ʂDBANZXBean
 * 
 */
public class CommonBeanImpl implements CommonBean {

    /**
     * V[PX̐ڔ
     */
    private final String SEQ_SUFIX = "_SEQ_001";

    /**
     * LogB
     */
    private static Log log = LogFactory.getLog(CommonBeanImpl.class);

    /**
     * QƌnDAOB
     */
    private QueryDAO queryDAO = null;

    /**
     * QƌnDAOݒ肷B
     * 
     * @param queryDAO QƌnDAO
     */
    public void setQueryDAOwhithoutLogging(QueryDAO queryDAOwhithoutLogging) {
        this.queryDAO = queryDAOwhithoutLogging;
    }

    /**
     * V[PXR[h̕os
     * 
     * @param seqName V[PX
     * @return String ő̃V[PX
     */
    public String executeGetSeqCode(String seqName) {
        String ret = null;

        ret = this.queryDAO.executeForObject("cmnsvc.sysCodeReader", seqName,
                String.class);

        if (log.isDebugEnabled()) {
            log.debug("擾V[PXR[h́F" + ret);
        }

        return ret;
    }

    /**
     * V[PXR[h̕osiόj
     * 
     * @param seqName V[PX
     * @param accuracy 
     * @return String ő̃V[PX
     */
    public String executeGetSeqCodeVariablePrecision(String seqName,
            int accuracy) {
        SysCodeReaderVariablePrecisionParam param = new SysCodeReaderVariablePrecisionParam();
        String ret = null;

        StringBuilder sb = new StringBuilder();
        sb.append("FM");
        for (int i = 0; i < accuracy; i++) {
            sb.append("0");
        }

        param.setSeqName(seqName);
        param.setAccuracy(sb.toString());

        ret = this.queryDAO.executeForObject(
                "cmnsvc.sysCodeReaderVariablePrecision", param, String.class);

        if (log.isDebugEnabled()) {
            log.debug("擾V[PXR[h́F" + ret);
        }

        return ret;
    }

    /**
     * VXeR[h擾B
     * 
     * @param tblName e[u
     * @return String VXeR[h
     */
    public String executeGetSysCode(String tblName) {
        String ret = null;

        String seqName = tblName + SEQ_SUFIX;

        if (log.isDebugEnabled()) {
            log.debug("VXeR[h̎擾");
            log.debug("V[PXF" + seqName);
        }

        if (tblName == null) {
            return null;
        }

        ret = this.queryDAO.executeForObject("cmnsvc.sysCodeReader", seqName,
                String.class);

        if (log.isDebugEnabled()) {
            log.debug("擾VXeR[h́F" + ret);
        }

        return ret;
    }

    /**
     * VXeR[h擾iόjB
     * 
     * @param tblName e[u
     * @param accuracy 
     * @return String VXeR[h
     */
    public String executeGetSysCodeVariablePrecision(String tblName,
            int accuracy) {
        SysCodeReaderVariablePrecisionParam param = new SysCodeReaderVariablePrecisionParam();
        String ret = null;

        String seqName = tblName + SEQ_SUFIX;

        if (log.isDebugEnabled()) {
            log.debug("VXeR[h̎擾");
            log.debug("V[PXF" + seqName);
        }

        if (tblName == null) {
            return null;
        }

        StringBuilder sb = new StringBuilder();
        sb.append("FM");
        for (int i = 0; i < accuracy; i++) {
            sb.append("0");
        }

        param.setSeqName(seqName);
        param.setAccuracy(sb.toString());

        log.info(param.getSeqName());
        log.info(param.getAccuracy());
        
        
        ret = this.queryDAO.executeForObject(
                "B003002.sysCodeReaderVariablePrecision", param, String.class);

        if (log.isDebugEnabled()) {
            log.debug("擾VXeR[h́F" + ret);
        }

        return ret;
    }

    /**
     * VXe擾
     * 
     * @return Timestamp VXe
     */
    public Timestamp executeGetCurrentTime() {
        Timestamp result = null;

        Object resultObj = this.queryDAO.executeForObject(
                "B003002.currentTimeReader", null, Object.class);

        if (resultObj instanceof Timestamp) {
            result = (Timestamp) resultObj;
        } else if (resultObj instanceof oracle.sql.TIMESTAMP) {
            // OracleΉ
            try {
                result = ((oracle.sql.TIMESTAMP) resultObj).timestampValue();
            } catch (SQLException e) {
                log.warn("oracle.sql.TIMESTAMP convert error.", e);
            }
        }

        if (log.isDebugEnabled()) {
            log.debug("擾VXéF" + result);
        }

        return result;

    }

    /**
     * VXet擾
     * 
     * @return Date VXet
     */
    public Date executeGetCurrentDate() {
        Date ret = null;

        ret = this.queryDAO.executeForObject("B003002.currentDateReader", null,
                Date.class);

        if (log.isDebugEnabled()) {
            log.debug("擾VXet́F" + ret);
        }
        return ret;

    }

}
