package jp.terasoluna.batch.functionsample.b003;

import jp.terasoluna.fw.batch.blogic.AbstractTransactionBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 񓯊֘ATv<br>
 * 
 * OFJOB_CONTROLe[uJOB_CONTROL_SEQ_001e[u쐬ĂƁB <br>
 * <br>
 * TveFWuǗe[uփWu𓊓TvB
 * 
 */
public class B003002BLogic extends AbstractTransactionBLogic {

	private Log log = LogFactory.getLog(B003002BLogic.class);

	private static final int BATCH_NORMAL_END = 0;

	private static final int BATCH_ABNORMAL_END = 255;

	@Autowired
	BatchEntryService batchEntrySvc = null;

	@Override
	public int doMain(BLogicParam param) {

		if (param == null) {
			log.error("param not found.");
			return BATCH_ABNORMAL_END;
		}

		log.info(param.toString());
		
		// p[^쐬
		BatchEntryParam batchEntryParam = new BatchEntryParam();

		batchEntryParam.setJobAppCd(param.getJobArgNm1());
		
		// WuǗe[uo^
		BatchEntryResult result = batchEntrySvc.writeJobTable(batchEntryParam);
		if (result == null	|| (result != null 
				&& result.getEndCode() != BatchEntryService.BATCH_ENTRY_END_CODE_NORMAL)) {
			log.error("writeJobTable error.");
			return BATCH_ABNORMAL_END;
		}

		return BATCH_NORMAL_END;
	}

}
