package jp.terasoluna.batch.functionsample.b002;

import jp.terasoluna.fw.batch.blogic.AbstractTransactionBLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupport;
import jp.terasoluna.fw.batch.dao.support.BatchUpdateSupportImpl;
import jp.terasoluna.fw.dao.UpdateDAO;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileQueryDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * t@C-DB֘AWuiob`XVj̃Tv<br>
 * <br>
 * OFC:\tmpzinput.csvt@Czu邱<br>
 * <br>
 * TveFt@Cǂݍ݁ADBɃob`XVTvB
 */
public class B002003BLogic extends AbstractTransactionBLogic {

    private Log log = LogFactory.getLog(B002003BLogic.class);

    private static final int BATCH_NORMAL_END = 0;

    @Autowired
    @Qualifier("csvFileQueryDAO")
    private FileQueryDAO csvFileQueryDAO = null;

    @Autowired
    @Qualifier("updateDAO")
    private UpdateDAO updateDAO = null;

    @Override
    public int doMain(BLogicParam arg0) {

        // EMPLOYEEe[ȕ
        updateDAO.execute("B002003.deleteEmployees", null);

        // ob`XVT|[g
        BatchUpdateSupport batchUpdate = new BatchUpdateSupportImpl();

        FileLineIterator<CsvRecord> recordIterator = csvFileQueryDAO.execute(
                "C:\\tmp\\input.csv", CsvRecord.class);

        try {

            while (recordIterator.hasNext()) {
                CsvRecord record = recordIterator.next();
                log.info("ID:" + record.getId() + " FIMILYNAME:"
                        + record.getFamilyName() + " FIRSTNAME:"
                        + record.getFirstName() + " AGE:" + record.getAge());

                // ob`XVXgɓo^
                batchUpdate.addBatch("B002003.insertEmployees", record);

                // 1000ƂɃob`XVs
                if (batchUpdate.size() >= 1000) {
                    // ob`XVs
                    batchUpdate.executeBatch(updateDAO);
                }
            }
        } finally {
            // t@C̃N[Y
            recordIterator.closeFile();
        }

        // ob`XVs
        batchUpdate.executeBatch(updateDAO);

        // I
        return BATCH_NORMAL_END;
    }

}
