package jp.terasoluna.batch.functionsample.b002;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * t@C-DB֘AWũTv<br>
 * <br>
 * 
 * OFEMPLOYEEe[u쐬Ă<br><br>
 * TveF DBQƂAt@C(C:\\tmp\\result002002.csv)ɏoTvB
 * 
 */
public class B002002BLogic implements BLogic {

	private Log log = LogFactory.getLog(B002002BLogic.class);

	private static final int BATCH_NORMAL_END = 0;
	
	
	
	@Autowired
	@Qualifier("queryDAO")
	private QueryDAO queryDAO = null;
	
	@Autowired
	@Qualifier("csvFileUpdateDAO")
	private FileUpdateDAO csvFileUpdateDAO = null;


	public int execute(BLogicParam arg0) {

		List<CsvRecord> record = queryDAO.executeForObjectList("B002002.selectEmployees", null);
		
		FileLineWriter<CsvRecord> fileLineWriter = csvFileUpdateDAO.execute(
				"C:\\tmp\\result002002.csv", CsvRecord.class);

		List<String> header = new ArrayList<String>();
		header.add("header");
		List<String> footer = new ArrayList<String>();
		footer.add("footer");

		try {
			// wb_̏o
			fileLineWriter.printHeaderLine(header);

			for(CsvRecord i : record){
				
				log.info("ID:" + i.getId() + " FIMILYNAME:"
						+ i.getFamilyName() + " FIRSTNAME:"
						+ i.getFirstName() + " AGE:" + i.getAge());

				// f[^̏o
				fileLineWriter.printDataLine(i);
			}
			
			// tb_̏o
			fileLineWriter.printTrailerLine(footer);
		} finally {
			// t@C̃N[Y
			fileLineWriter.closeFile();
		}

		// I
		return BATCH_NORMAL_END;
	}

}
