package jp.terasoluna.batch.functionsample.b000;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.batch.blogic.BLogic;
import jp.terasoluna.fw.batch.blogic.vo.BLogicParam;
import jp.terasoluna.fw.batch.util.MessageUtil;
import jp.terasoluna.fw.batch.util.ValidationUtil;
import jp.terasoluna.fw.file.dao.FileLineIterator;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileQueryDAO;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.Validator;

/**
 * t@C֘AWũTv<br>
 * <br>
 * 
 * OFC:\tmpzinput.csvt@Czu邱 <br>
 * <br>
 * TveF input.csvt@CǂݎA̓`FbNsTvB
 * 
 * 
 */
public class B000004BLogic implements BLogic {

	private Log log = LogFactory.getLog(B000004BLogic.class);

	private static final int BATCH_NORMAL_END = 0;
	private static final int BATCH_ABNORMAL_END = 255;

	@Autowired
	@Qualifier("csvFileQueryDAO")
	private FileQueryDAO csvFileQueryDAO = null;

	@Autowired
	@Qualifier("csvFileUpdateDAO")
	private FileUpdateDAO csvFileUpdateDAO = null;

	@Autowired
	@Qualifier("beanValidator")
	private Validator beanValidator = null;

	public int execute(BLogicParam arg0) {

		int returnCode = BATCH_NORMAL_END;

		FileLineIterator<CsvRecord> recordIterator = csvFileQueryDAO.execute(
				"C:\\tmp\\input2.csv", CsvRecord.class);

		FileLineWriter<CsvRecord> fileLineWriter = csvFileUpdateDAO.execute(
				"C:\\tmp\\result.csv", CsvRecord.class);

		List<String> header = new ArrayList<String>();
		header.add("header");
		List<String> footer = new ArrayList<String>();
		footer.add("footer");

		try {
			// wb_̏o
			fileLineWriter.printHeaderLine(header);

			while (recordIterator.hasNext()) {
				CsvRecord record = recordIterator.next();
				log.info("ID:" + record.getId() + " FIMILYNAME:"
						+ record.getFamilyName() + " FIRSTNAME:"
						+ record.getFirstName() + " AGE:" + record.getAge());

				// ̓`FbN
				Errors errors = ValidationUtil.validate(beanValidator, record);
				if (errors.hasErrors()) {
					List<FieldError> fes = ValidationUtil
							.getFieldErrorList(errors);

					for (FieldError fe : fes) {
						// G[bZ[WOɏo
						if (log.isErrorEnabled()) {
							log.error(MessageUtil.getMessage(fe.getCode(), fe
									.getArguments()));
						}
					}
					returnCode = BATCH_ABNORMAL_END;
					continue;
				}

				// f[^̏o
				fileLineWriter.printDataLine(record);

			}
			// tb_̏o
			fileLineWriter.printTrailerLine(footer);
		} finally {
			// t@C̃N[Y
			recordIterator.closeFile();
			fileLineWriter.closeFile();
		}

		// I
		return returnCode;
	}

}
