/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.commonj.init;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobStatusSummarizer;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.init.JobInfo;
import jp.terasoluna.fw.batch.openapi.JobContext;

/**
 * UɂqWuNpCNXB<br>
 * eWũbZ[WŎ󂯎qWup̃WuReLXg<br>
 * gpĎqWũWusB
 * 
 * @deprecated
 */
public class ChildJobExecutor extends JobExecutor {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(ChildJobExecutor.class);

    /**
     * WuReLXgB
     */
    private JobContext jobContext = null;

    /**
     * WusB<br>
     * w肳ꂽWuReLXg̏ɊÂăWusB
     * 
     * @param jobInfo Wu˗
     * @param jobContext WuReLXg
     * @return Wus
     */
    public JobStatus execute(JobInfo jobInfo, JobContext jobContext) {
        // JnOo
        printStartLog(jobContext);
        
        // WuBeanFactory
        ConfigurableApplicationContext jobFactory = getJobBeanFactory(jobInfo);

        // }lW[擾
        Workable<WorkUnit> jobManager = getJobManager(jobFactory);

        // WuԂ̏
        jobStatus = this.getJobStatus(jobFactory, jobContext);

        // It@CĎXbhɓo^
        initEndFileChecker(jobStatus, jobContext);

        WorkUnit rootWorkQueueElement = getWorkUnit(jobContext);

        jobManager.work(rootWorkQueueElement, jobStatus);

        ((JobStatusSummarizer) jobFactory.getBean(JOBSTATUS_SUMMARIZER))
                .summarize(jobStatus);

        setDefaultJobExitCode(jobStatus);

        if (!(Boolean) jobFactory.getBean(USECACHE_NAME)) {
            jobFactory.close();
        }

        // WȕIOo
        printEndLog(jobStatus);

        return jobStatus;
    }

    /**
     * Wu̔񓯊sB
     * 
     */
    @Override
    public void run() {
        jobStatus = execute(getJobInfo(), jobContext);
    }

    /**
     * WuReLXgWuXe[^X쐬B
     * 
     * @param jobFactory Wu<code>BeanFactory</code>
     * @param jobContext WuReLXg
     * @return WuXe[^X
     */
    protected JobStatus getJobStatus(ConfigurableApplicationContext jobFactory,
            JobContext jobContext) {
        
        JobStatus initJobStatus = null;

        if ((Boolean) jobFactory.getBean(USE_MONITORABLE)) {
            initJobStatus = (JobStatus) jobFactory
                    .getBean(MONITORABLE_JOBSTATUS_NAME);
        } else {
            initJobStatus = (JobStatus) jobFactory.getBean(JOBSTATUS_NAME);
        }

        initJobStatus.setJobRequestNo(jobContext.getJobRequestNo());
        initJobStatus.setJobId(jobContext.getJobId());
        initJobStatus.setJobState(JobStatus.STATE.STARTED);
        initJobStatus.setPartitionNo(jobContext.getPartitionNo());
        initJobStatus.setPartitionKey(jobContext.getPartitionKey());

        return initJobStatus;
    }

    /**
     * WůJnOB
     * 
     * @param jobContext WuReLXg
     */
    protected void printStartLog(JobContext jobContext) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Child job processing START. : [jobId=");
            logStr.append(jobContext.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobContext.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobContext.getPartitionNo());
            logStr.append("] [StartType=");
            logStr.append(isAsync() ? JobContext.START_TYPE.ASYNC
                    : JobContext.START_TYPE.SYNC);
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }

    /**
     * WȕIOB
     * 
     * @param jobStatus WuXe[^X
     */
    protected void printEndLog(JobStatus jobStatus) {
        if (log.isDebugEnabled()) {
            StringBuilder logStr = new StringBuilder();
            logStr.append("Child job processing END. : [jobId=");
            logStr.append(jobStatus.getJobId());
            logStr.append("] [jobRequestNo=");
            logStr.append(jobStatus.getJobRequestNo());
            logStr.append("] [partitionNo=");
            logStr.append(jobStatus.getPartitionNo());
            logStr.append("] [StartType=");
            logStr.append(isAsync() ? JobContext.START_TYPE.ASYNC
                    : JobContext.START_TYPE.SYNC);
            logStr.append("] [jobExitCode=");
            logStr.append(jobStatus.getJobExitCode());
            logStr.append("]");
            log.debug(logStr.toString());
        }
    }

    /**
     * WuXe[^X̎擾B
     * 
     * @return jobStatus WuXe[^X
     */
    @Override
    public JobStatus getJobStatus() {
        return jobStatus;
    }

    /**
     * WuReLXg̐ݒB
     * 
     * @param jobContext WuReLXg
     */
    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }
}
